%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% CLOSURE ENERGY BUDGET  DETERMINATION SURFACE TEMPERATURE %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function[DQ]=Surface_Temperature(Ts,dt,Ta,ea,Latm,SvF,Pre,...
    Csno,Crock,Curb,Cbare,Ccrown,Cwat,Cice,...
    hc_H,hc_L,SnoDep,ydepth,ICE_D,Cdeb,LAI_H,LAI_L,SAI_H,SAI_L,...
    RabsbSun_vegH,RabsbShd_vegH,Rabsb_soiH,...
    RabsbSun_vegL,RabsbShd_vegL,Rabsb_soiL,FsunH,FshdH,...
    FsunL,FshdL,Rabsb_sno,Rabsb_bare,Rabsb_urb,Rabsb_wat,Rabsb_rock,Rabsb_ice,Rabsb_deb,...
    e_sno,e_gr,e_sur,Cicew,Csnow,CLitter,...
    dw_L,dw_H,dw_SNO,...
    In_H,In_L,In_urb,In_rock,SWE,In_SWE,...
    Pr_liq,Pr_sno,rs_sunH,rs_sunL,rs_shdH,rs_shdL,d_leaf_H,d_leaf_L,r_litter,r_soil,b_soil,alp_soil,...
    ms,dz,Zs,rsd,lan_dry,lan_s,cv_s,SPAR,L,Pe,O33,alpVG,nVG,Phy,s_SVG,bVG,Osat,Ohy,Oicetm1,Otm1,...
    Tstm1,Tdamptm1,Tdptm1,CTt,CTt_oth,OPT_FR_SOIL,OPT_STh,...
    zatm,disp_h,zom,zoh,zom_under,disp_h_H,zom_H,disp_h_L,zom_L,Ws,In_Litter,alp_litter,Lpho,Vavail,Vavail_plant_H,Vavail_plant_L,WAT_avail,ICEtm1,OPT_SoilTemp)
%%%%%%%%%%%%%%%%%%%%%
[ra]=Aerodynamic_Resistence(Ta,Ts,Pre,zatm,disp_h,zom,zoh,Ws,ea);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%rb_H=zeros(1,length(Ccrown)); rb_L=zeros(1,length(Ccrown));
%rap_H=zeros(1,length(Ccrown)); rap_L=zeros(1,length(Ccrown));
%for i=1:length(Ccrown)
%%%%%%% Undercanopy and Leaf  resitence
%    if  (hc_L(i) == 0) && (hc_H(i) == 0)
%        rap_H(i) = 0; rap_L(i) = 0 ;
%        rb_H(i)=0; rb_L(i)=0;
%    else
%        [rap_H(i),rap_L(i),rb_H(i),rb_L(i)]=Undercanopy_Leaf_Resistence(Ws,Ta,Ts,hc_H(i),hc_L(i),...
%            (LAI_H(i)+SAI_H(i)),(LAI_L(i)+SAI_L(i)),d_leaf_H(i),d_leaf_L(i),...
%            zatm,disp_h,zom,zom_under,SnoDep,disp_h_H(i),zom_H(i),disp_h_L(i),zom_L(i));
%    end
%end
[rap_H,rap_L,rb_H,rb_L]=Undercanopy_Leaf_Resistence2(Ws,Ta,Ts,Ccrown,hc_H,hc_L,...
    (LAI_H+SAI_H),(LAI_L+SAI_L),d_leaf_H,d_leaf_L,...
    zatm,disp_h,zom,zom_under,SnoDep,disp_h_H,zom_H,disp_h_L,zom_L);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Net Radiation
[Rnet]=Net_Radiation_Manager(Ts,Latm,SvF,...
    Csno,Crock,Curb,Cwat,Cbare,Cice,Ccrown,...
    hc_L,SnoDep,ydepth,ICE_D,Cdeb,LAI_H,LAI_L,SAI_H,SAI_L,...
    RabsbSun_vegH,RabsbShd_vegH,Rabsb_soiH,...
    RabsbSun_vegL,RabsbShd_vegL,Rabsb_soiL,FsunH,FshdH,...
    FsunL,FshdL,Rabsb_sno,Rabsb_bare,Rabsb_urb,Rabsb_wat,Rabsb_rock,Rabsb_ice,Rabsb_deb,...
    e_sno,e_gr,e_sur,Cicew,Csnow);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Thermal properties soil
if Crock ==1 || Curb ==1  || Cwat ==1
    [G]=Soil_Heat(dt,Ts,Tstm1,Tdamptm1,CTt_oth);
else
    if OPT_SoilTemp==1
        %%% Soil Heat Flux
        %[G]=Soil_Heat_Profile_New(Ts,dt,Tdptm1,ms,dz,Zs,Pre,rsd,lan_dry,lan_s,cv_s,SPAR,L,Pe,O33,alpVG,nVG,...
        %    Phy,s_SVG,bVG,Osat,Ohy,Oicetm1,Otm1,NaN,OPT_FR_SOIL,OPT_STh);
        
        [G]=Soil_Heat(dt,Ts,Tstm1,Tdamptm1,CTt);
    else
        [G]=Soil_Heat(dt,Ts,Tstm1,Tdamptm1,CTt);
    end
end
%%% Heat Fluxes
[H,QE,Qv]=Heat_fluxes(dt,...
    Ta,Ts,ea,Pre,Csno,Crock,Curb,Cwat,Cbare,Cice,Cicew,Csnow,CLitter,Cdeb,...
    dw_L,dw_H,dw_SNO,Ccrown,FsunH,FshdH,...
    FsunL,FshdL,LAI_H,LAI_L,SAI_H,SAI_L,...
    In_H,In_L,In_urb,In_rock,SWE,In_SWE,...
    Pr_liq,Pr_sno,ra,rs_sunH,rs_sunL,rs_shdH,rs_shdL,rb_H,rb_L,rap_H,rap_L,r_litter,...
    r_soil,b_soil,alp_soil,Vavail,Vavail_plant_H,Vavail_plant_L,WAT_avail,ICEtm1,In_Litter,alp_litter);
%%%%%%% Energetic Balance
DQ = Rnet-H-QE-G+Qv-Lpho;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
return