from qgis.analysis import QgsZonalStatistics

## Fonction de calcul de la valeur de la moyenne de la couche raster pour 
## chaque polygonne d'une couche vectorielle 

# fonction pour faire le zonal statistics avec les parametres suivants :
# polygon_layer : la couche vectorielle sur laquelle faire le calcul
# raster_layer : la couche raster depuis laquelle on calcul la valeur moyenne dans le polygonne
# analyse_name_pec : la chaine de caractere qui precede le nom du nouvel attribut dans la couche vectorielle
# QgsZonalStatistics.Type : Le type de calcul que l'on veut effectuer (Mean, Min, Max etc.)
def do_zonal_mean(polygon_layer, raster_layer, analyse_name_prec):

    # selection des elements du calcul de zonal statistics
    zoneStat = QgsZonalStatistics (polygon_layer, raster_layer, analyse_name_prec, 1, QgsZonalStatistics.Mean)
    # calcul et ajout automatique du nouvel attibut dans la couche polygon_layer
    zoneStat.calculateStatistics(None)


## Pour sauvegarder la couche avec les géométries modifiées dans une nouvelle couche :

# sauvegarde d'une couche existante comme nouvelle couche shapefile dans le chemin couche_nouveau_chemin
writer = QgsVectorFileWriter.writeAsVectorFormat(couche_initiale, couche_nouveau_chemin, 'utf-8', QgsCoordinateReferenceSystem(), 'ESRI Shapefile')