import osmnx as ox
import networkx as nx
import folium

ouchy = (46.5065, 6.6265)
vidy = (46.5200525050661, 6.5898050240831525)

G = ox.graph_from_place("Lausanne, Switzerland", network_type="bike")

orig_node = ox.distance.nearest_nodes(G, X=ouchy[1], Y=ouchy[0])
dest_node = ox.distance.nearest_nodes(G, X=vidy[1], Y=vidy[0])

route = nx.shortest_path(G, orig_node, dest_node, weight="length")

distance_m = sum(ox.utils_graph.get_route_edge_attributes(G, route, "length"))
distance_km = distance_m / 1000
speed_kmh = 15
time_min = (distance_km / speed_kmh) * 60 

m = folium.Map(location=[46.2044, 6.1432], zoom_start=13)

ox.plot_graph_folium(G, graph_map=m, color="gray", weight=1, opacity=0.5)

route_coords = [(G.nodes[n]["y"], G.nodes[n]["x"]) for n in route]
folium.PolyLine(route_coords, color="blue", weight=5, opacity=0.7, tooltip="Trajet vélo").add_to(m)

folium.Marker(ouchy, popup="Ouchy", icon=folium.Icon(color="green")).add_to(m)
folium.Marker(vidy, popup="Vidy", icon=folium.Icon(color="blue")).add_to(m)

popup_text = f"Distance: {distance_km:.2f} km<br>Temps estimé: {time_min:.0f} min"
folium.Marker(route_coords[len(route_coords)//2], popup=popup_text, icon=folium.Icon(color="blue")).add_to(m)

m.save("trajet_velo_folium.html")

