import osmnx as ox
import networkx as nx
import matplotlib.pyplot as plt

def shortest_path_bike(start, end):
    # Télécharger le graphe routier de Genève
    G = ox.graph_from_place("Genève, Switzerland", network_type='bike')
    
    # Convertir les adresses en coordonnées GPS
    start_location = ox.geocode(start)
    end_location = ox.geocode(end)
    
    # Trouver les nœuds OSM les plus proches des coordonnées
    orig_node = ox.nearest_nodes(G, start_location[1], start_location[0])
    dest_node = ox.nearest_nodes(G, end_location[1], end_location[0])
    
    # Calculer le chemin le plus court en distance
    shortest_route = nx.shortest_path(G, orig_node, dest_node, weight='length')
    
    # Afficher le chemin sur une carte
    fig, ax = ox.plot_graph_route(G, shortest_route, route_linewidth=3, node_size=0, bgcolor='white')
    plt.show()

# Points de départ et d'arrivée
start_point = "Servette, Genève, Switzerland"
end_point = "Eaux-Vives, Genève, Switzerland"

shortest_path_bike(start_point, end_point)


