var states_list = ['Alabama','Texas']

var satellite = 'L8';
var date_start = '2022-05-01';
var date_end = '2022-08-31';
var use_ndvi = true;

var LandsatLST = require('users/sofiaermida/landsat_smw_lst:modules/Landsat_LST.js')

calculate_LST(states_list);

function calculate_LST(states_list){
  states_list.forEach(function(state) {
    // trouver les geometry correspondants aux etats selectionnes
    var aoi = ee.FeatureCollection("FAO/GAUL_SIMPLIFIED_500m/2015/level1").filter(ee.Filter.eq('ADM1_NAME', state)).geometry();
    // récupère les données landsat
    var LandsatColl = LandsatLST.collection(satellite, date_start, date_end, aoi, use_ndvi);
    var compositeImage = LandsatColl.median();
    var clippedImage = compositeImage.clip(aoi);

    // récupère le LST pour les états selectionnees et les dates sélectionnes
    Export.image.toDrive({
      image: clippedImage.select('LST'),
      description: 'LST_Arusha_May_2022'+'_'+state,
      scale: 30,
      region: aoi,
      fileFormat: 'GeoTIFF',
    });
  });
}