import pandas as pd
from pandarallel import pandarallel
from multiprocessing import freeze_support
import time

def carre_lent(x):
    import time
    time.sleep(0.000001)
    return x * x

def main():
    pandarallel.initialize(progress_bar=True, nb_workers=4)
    df = pd.DataFrame({"nombre": range(1, 50000)})

    start = time.time() 
    df["carre_seq"] = df["nombre"].apply(carre_lent)
    print("Temps séquentiel :", time.time() - start, "sec")

    start = time.time()
    df["carre_par"] = df["nombre"].parallel_apply(carre_lent)
    print("Temps parallèle:", time.time() - start, "sec")


if __name__ == "__main__":
    freeze_support()
    main()
