import time
import urllib.parse
import requests
import pyproj
from pyproj import Transformer

def main():
    search_OSM("Place de Jargonnant 3")

def search_OSM(adresse):
    WGS84       = pyproj.CRS("EPSG:4326")
    CH1903_LV95 = pyproj.CRS("EPSG:2056")

    base_url = 'https://nominatim.openstreetmap.org/search'
    params   = {'q': adresse, 'format': 'json'}
    headers  = {
        'User-Agent': 'MonScriptGeo/1.0'
    }

    response = None
    max_attempts = 3
    for attempt in range(1, max_attempts+1):
        try:
            resp = requests.get(base_url, params=params, headers=headers, timeout=5)
            if resp.status_code == 200:
                response = resp.json()
                break
            else:
                time.sleep(1)
        except requests.RequestException as e:
            print(f"Erreur réseau (tentative {attempt}) :", e)
            time.sleep(1)
    else:
        print(f"Echec après {max_attempts} tentatives pour '{adresse}'")
        return

    if not response:
        print(f"Aucune donnée renvoyée pour '{adresse}'")
        return
    if isinstance(response, list) and not response:
        print(f"Aucun résultat géographique pour '{adresse}'")
        return

    lat = float(response[0]["lat"])
    lon = float(response[0]["lon"])
    transformer = Transformer.from_crs(WGS84, CH1903_LV95, always_xy=True)
    x, y = transformer.transform(lon, lat)

    print(f"Coordonnées pour '{adresse}':\n  x = {x}\n  y = {y}\n")

if __name__ == "__main__":
    main()
