#ifndef UTIL_H
#define UTIL_H 
#include <stdlib.h>
#include <stdio.h>
#include <stdbool.h>
#include <math.h>
#include <webots/robot.h> 			// WEBOTS SPECIFIC
#include <webots/position_sensor.h> // WEBOTS SPECIFIC

#define RAD2DEG(X)      X / M_PI * 180.0
#define DEG2RAD(X)      X * M_PI / 180.0
#define WHEEL_AXIS 		0.057
#define WHEEL_RADIUS 	0.020

#define NB_SENSORS 8
#define TIME_STEP 64
#define RANGE (1024 / 2)
#define MAXIMUM_SPEED  1000
#define MAX_SPEED_WEB      6.28    // Maximum speed webots

// NOTE: this is not truly proper but is done here to simplify function headers.
// One should rather define those handlers in the main and pass them onwards wherever needed.
WbDeviceTag left_motor; //handler for left wheel of the robot
WbDeviceTag right_motor; //handler for the right wheel of the robot
WbDeviceTag left_encoder; //handler for the left wheel encoder of the robot
WbDeviceTag right_encoder;//handler for the right wheel encoder of the robot

/* throws an error and aborts the program
 */
#define THROW_ERR(X,Y)  throw_error(X,Y)
void throw_error(bool test, char* message);

/* calculates and sets motor speeds for braitenberg
 * Input: current distance sensor values
 * Remark: 'const' indicates that this function will not change the values of ds_value
 */
void braitenberg_step(const double ds_value[NB_SENSORS]);

/* Initializes the motors in WB
 */
void init_robot_wb();

/* Transforms IR measurements to distance
 */ 
double IR_to_distance(double proximity);


////// MATRIX UTILITIES /////

/* Multiplies two matrices mat1[][] and mat2[][]
 * and returns result.
 * (m1) x (m2) and (n1) x (n2) are dimensions
 * of given matrices.
 */
void multiply(int m1, int m2, const double mat1[][m2], int n1,
              int n2, const double mat2[][n2], double res[m1][n2]);

/* Inverses the given matrix in place
*/
void inverse(int matsize,double mat[matsize][matsize]);

/* Adds two matrices mat1[][] and mat2[][] and returns result.
 * (m1) x (m2) are dimensions of given matrices.
 */
void add(int m1, int m2, const double mat1[m1][m2], const double mat2[m1][m2], double res[m1][m2]);

/* Substracts matrice mat2[][] from mat1[][] and returns result.
 * (m1) x (m2) are dimensions of given matrices.
 */
void substract(int m1, int m2, const double mat1[m1][m2], const double mat2[m1][m2], double res[m1][m2]);

/* Prints the matrix of dimensions NxM to stdout
 */ 
void print(int N, int M, double mat[N][M]);

#endif //UTIL_H