/**
 * NOTE: this code is not used in the lab anymore. 
 * It can be used to generate the pose ground truth data.
*/

#include <webots/robot.h>
#include <webots/supervisor.h>
#include <stdio.h>

#include <math.h>
#define TIME_STEP 64

int main(int argc, const char* argv[])
{
  wb_robot_init();

  // Get light nodes
  WbNodeRef robot;
  robot = wb_supervisor_node_get_from_def("E_PUCK");
  WbFieldRef epuck_translation;
  WbFieldRef epuck_rotation;
  epuck_translation =  wb_supervisor_node_get_field(robot, "translation");
  epuck_rotation = wb_supervisor_node_get_field(robot, "rotation");


  // Main loop
  FILE* logfile= fopen("true_position.txt", "w");
  float elapsed = 0.f;
  while (wb_robot_step(TIME_STEP) != -1 && wb_robot_get_time()<240) {
    double x,y,th;
    x = (double)wb_supervisor_field_get_sf_vec3f(epuck_translation)[1];  // Xrobot = Ywebots
    y = -(double)wb_supervisor_field_get_sf_vec3f(epuck_translation)[0];  // Yrobot = -Xwebots
    th = (double)wb_supervisor_field_get_sf_rotation(epuck_rotation)[3]; // heading

    // printf("True: %f %f %f\n", x, y, th);
    
    // write to file
    fprintf(logfile, "%f %f %f %f\n", elapsed, x, y, th);
    fflush(logfile);

  
    elapsed += TIME_STEP / 1000.f;
  }

  fclose(logfile);
  wb_robot_cleanup();
  return 0;
}
