%% Parameters
simtime = 1200; % in timesteps
odometry_noise = 0.05; % relative noise
odometry_drift = 0;   % absolute noise, simulates for example inclinaison of terrain
localization_noise = 0.25; % absolute noise, 0.25 corresponds to 0.25m noise

% variables
true_x      = zeros(1200,1);
est_odo_x   = zeros(1200,1);
est_kal_x   = zeros(1200,1);

%% 2D Kalman vars
kalman_dimension = 2; 
mu = zeros(2,1200); % mu = [x,v]', u = odo
%%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%
A = [0];      	% TODO: CHANGE THIS, hint: x' = x + v*dt (dt = 1) 
B = [0];        % TODO: CHANGE THIS, hint: v' = odo (see `odo` at line 38)
Sigma = [0];    % TODO: CHANGE THIS
R = [0];        % TODO: CHANGE THIS
C = [0];        % TODO: CHANGE THIS
Q = [0];        % TODO: CHANGE THIS
I = [0];        % TODO: CHANGE THIS
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Simulates the robot, this corresponds to the 'true' position of the robot
for time=2:1200

	% set the movement's velocity norm and direction
    if mod(time,200) > 100
        mov = 0.1;
    else
        mov = -0.1;
    end    
    
    % updating true value
    true_x(time) = true_x(time-1) + mov;
    % updating odometry
    odo = mov + randn(1)*odometry_noise + odometry_drift; % DO NOT TOUCH THIS
    est_odo_x(time) = est_odo_x(time-1) + odo;
    
    %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%
    % 2D Kalman - prediction
    mu(:,time) = mu(:,time-1);                % TODO: CHANGE THIS
    Sigma= Sigma;                                        % TODO: CHANGE THIS
    est_kal_x(time) = mu(1,time);
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    %% feature-based odometry correction
    if mod(time,200) == 0 % our 'feature' is at one end of the path
        measurement = true_x(time) + randn(1)*localization_noise; % DO NOT TOUCH THIS
                
        % Updating the odometry
        %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%         
        % Kalman 2D update  
        K = 0;                                              % TODO: CHANGE THIS
        mu(:,time) = mu(:,time);         % TODO: CHANGE THIS
        Sigma = Sigma;                                           % TODO: CHANGE THIS
        est_kal_x(time) = mu(1,time);
       
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
end

%% Plots result
% create slightly increasing y to better visualize result
% Note: feel free to modify the plot colors to improve the visualization
y=1:simtime;
figure
hold on
plot(true_x,y,"r",'LineWidth',2);
plot(est_odo_x,y,'c');
plot(est_kal_x,y,'g');
legend("True Position","Odometry Position","Kalman Filter Position")
xlabel("x [m]");
ylabel("time [s]");

