%% Parameters
simtime = 1200; % in timesteps
odometry_noise = 0.05; % relative noise
odometry_drift = 0;   % absolute noise, simulates for example inclinaison of terrain
localization_noise = 0.25; % absolute noise, 0.25 corresponds to 0.25m noise

% variables
true_x      = zeros(1200,1); % ground truth of the robot position
est_odo_x   = zeros(1200,1); % estimated robot position by using odometry 
est_fp_x    = zeros(1200,1); % estimated robot position by fusing odometry and measurements information with Fraser Potter
est_kal_x   = zeros(1200,1); % estimated robot position by fusing odometry and measurements information with Kalman Filter

%% Fuse the information by using Fraser Potter
for time=2:1200
    if mod(time,200) > 100
        mov = 0.1;
    else
        mov = -0.1;
    end    
    
    % updating true value
    % Simulates the robot, this corresponds to the 'true' position of the robot
    true_x(time) = true_x(time-1) + mov;

    % updating odometry
    odo = mov + randn(1)*odometry_noise + odometry_drift; % DO NOT TOUCH THIS
    
    %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%
    est_odo_x(time) = est_odo_x(time-1) + odo;
    
    est_fp_x(time) = est_fp_x(time-1);                  % TODO: Q6: CHANGE THIS
  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % Detection of the feature
    if mod(time,200) == 0 % our 'feature' is at one end of the path
        measurement = true_x(time) + randn(1)*localization_noise; % DO NOT TOUCH THIS
                
        % Updating the position estimation by fusing the data from odometry
        % and measurment 
        %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%         
        
        odometry_noise_200 = sqrt(200*odometry_noise^2);
        est_fp_x(time) = measurement;                           % TODO: Q6: CHANGE THIS
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    end
end

%% Kalman variables
kalman_dimension = 1;
mu = zeros(1,1200);         % State variable
sigma = zeros(1, 1200);     % variance variable
K = 0; % Kalman gain

for time=2:1200

    if mod(time,200) > 100
        mov = 0.1;
    else
        mov = -0.1;
    end    
    
    % updating true value
    true_x(time) = true_x(time-1) + mov;
    % updating odometry
    odo = mov + randn(1)*odometry_noise + odometry_drift; % DO NOT TOUCH THIS
    
    %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%
    % Kalman prediction   
    % 1D Kalman - prediction
    mu(time) = mu(time-1);                          % Q9: TODO: CHANGE THIS
    sigma(time) = sigma(time-1);                    % Q10: TODO: CHANGE THIS
    est_kal_x(time) = mu(time);

  
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % Detection of the feature
    if mod(time,200) == 0 % our 'feature' is at one end of the path
        measurement = true_x(time) + randn(1)*localization_noise; % DO NOT TOUCH THIS
        
        % Updating the position estimation by fusing the data from odometry
        % and measurment 
        %%%%%%%%%%%%%%%%%%%%%%    CHANGE HERE    %%%%%%%%%%%%%%%%%%%        
        % 1D Kalman update 
        K = 0;                                              % Q11: TODO: CHANGE THIS
        sigma(time) = sigma(time-1);                        % Q11: TODO: CHANGE THIS
        mu(time) = mu(time);                                % Q11: TODO: CHANGE THIS
        est_kal_x(time) = mu(time);                        
    end
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end

%% Plots result
% create slightly increasing y to better visualize result
% Note: feel free to modify the plot colors to improve the visualization
y=1:simtime;
figure
hold on
plot(true_x,y,"r",'LineWidth',2);
plot(est_odo_x,y,'c');
plot(est_fp_x,y,'m');
plot(est_kal_x,y,'g');
legend("True Position","Odometry Position","Fraser-Poter Position","Kalman Filter Position")
xlabel("x [m]");
ylabel("time [s]");
