%Code that plots the calculated and the odometry/kalman-trajectory of the epuck
clear all
close all
clc

% paths (should be ok but if not, change here)
odo =  './../controllers/e-puck_kalman/no_kalman.txt';
kalm = './../controllers/e-puck_kalman/kalman.txt';
sup = './../controllers/supervisor/true_position.txt';


%% read data
if isfile(sup)
    fid_sup=fopen(sup,'rt');
    lines_sup = 0;
    while ~feof(fid_sup)
        lines_sup= lines_sup+1;
        current_line=fgets(fid_sup);
        traj_sup(lines_sup,:) = sscanf(current_line,"%f %f %f %f");

    end
    fclose(fid_sup);
end

if isfile(odo)
    fid_odo=fopen(odo,'rt');
    lines_odo = 0;
    while ~feof(fid_odo)
        lines_odo= lines_odo+1;
        current_line=fgets(fid_odo);
        traj_odo(lines_odo,:) = sscanf(current_line,"%f %f %f %f");

    end
    fclose(fid_odo);
end

if isfile(kalm)
    fid_kalm=fopen(kalm,'rt');
    lines_kalm = 0;
    while ~feof(fid_kalm)
        lines_kalm= lines_kalm+1;
        current_line=fgets(fid_kalm);
        traj_kalm(lines_kalm,:) = sscanf(current_line,"%f %f %f %f");

    end
    fclose(fid_kalm);
end
%% Plot
figure()
if isfile(sup)
    plot(traj_sup(:,3),traj_sup(:,2),'g')
hold on
end
if isfile(odo)
    plot(traj_odo(:,2),traj_odo(:,1),'b')
end
if isfile(kalm)
    plot(traj_kalm(:,2),traj_kalm(:,1),'r')
end
hold off
    
xlim([-1,1])
ylim([-1,1])
grid on
axis equal
set ( gca, 'xdir', 'reverse' )

legend("Real Position","Odometry Position","Kalman Position")
