function [x, vx] = odo_acc(x, vx, T, acc, acc_mean)
% Express the acceleration in frame A and remove the biais (Assume 1-D) 
ACC_MIN = 0.05;  % minimal acceptable acceleration 
ACC_COEF = 1.0; % calibration coeff (empirical)

if(abs(acc(1)) > ACC_MIN)
    acc_wx = (acc(1) - acc_mean(1)) * ACC_COEF;
else
    acc_wx = 0;
end

% Odometry in X 
vx = vx + acc_wx * T;

x = x + vx * T;

end