#include <webots/robot.h>
#include <webots/distance_sensor.h>
#include <webots/light_sensor.h>
#include <webots/camera.h>
#include <webots/accelerometer.h>

#include <stdio.h>

#define NB_SENSORS 8
#define TIME_STEP 16

int main(int argc, const char *argv[]) {
  int i;
  WbDeviceTag ds[NB_SENSORS];
  WbDeviceTag ls[NB_SENSORS];
  WbDeviceTag camera;
  WbDeviceTag accel;

  wb_robot_init();

  // get an enable distance sensors
  char ds_name[] = "ps0";
  for (i = 0; i < NB_SENSORS; ++i) {
    ds[i] = wb_robot_get_device(ds_name);
    wb_distance_sensor_enable(ds[i], TIME_STEP);
    ++ds_name[2];
  }
  
  // get an enable light sensors
  char ls_name[] = "ls0";
  for (i = 0; i < NB_SENSORS; ++i) {
    ls[i] = wb_robot_get_device(ls_name);
    wb_light_sensor_enable(ls[i], TIME_STEP);
    ++ls_name[2];
  }
  
  // get an enable camera
  camera = wb_robot_get_device("camera");
  wb_camera_enable(camera, TIME_STEP);
  
  // get an enable accelerometer
  accel = wb_robot_get_device("accelerometer");
  wb_accelerometer_enable(accel, TIME_STEP);
  
  // enable encoders
  //wb_differential_wheels_enable_encoders(TIME_STEP);

  // empty main loop
  while(wb_robot_step(TIME_STEP)!=-1) {
  }
  
  wb_robot_cleanup();
  return 0;
}
