// Lab6 software for Arduino shield board AXB02 from EPFL Disal
// with Disaplay 128x32 SSD1306, Temperature sensor SHT2x and 
// light sensor TSL2561.
// Tested Arduino board: MEGA
// C. Ercolani 20-10-2021


// Add these libraries
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include <Tsl2561.h> //from Joba
#include <Sodaq_SHT2x.h>
#include "mma8652.h" //from panStamp


//BUTTONS
#define BTN_UP 13 

// Initialize light sensor 
Tsl2561 Tsl(Wire);


// Initialize OLED screen
SSD1306AsciiWire oled;

// I2C address of Oled screen
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1


int frequency=10000;
int button_press=0;

//------------------------------------------------------------------------------


// to mimic Serial.printf() of esp8266 core for other platforms
char *format( const char *fmt, ... ) {
  static char buf[128];
  va_list arg;
  va_start(arg, fmt);
  vsnprintf(buf, sizeof(buf), fmt, arg);
  buf[sizeof(buf)-1] = '\0';
  va_end(arg);
  return buf;
}


// Get humidity from temperature sensor
float getHumidity()
{
   float h = SHT2x.GetHumidity();
   return h;
}

// Get temperature from temperature sensor
float getTemperature()
{
   float t = SHT2x.GetTemperature();
   return t;
}


void setup() {
  // Initialize I2C communication
  Wire.begin();
  Wire.setClock(400000L);

  // Initialize serial line for communication with computer
  Serial.begin(9600);

  // Initialize GPIO to control the buttons
  pinMode(BTN_UP,INPUT);

  //Init light sensor
  Tsl.begin();
  

 //Initialize the screen
#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();
   
}

//------------------------------------------------------------------------------
void loop() 
{

   uint32_t m = millis();
   
   oled.home();
   oled.set1X();
   

   
   // get and display temperature
   float t = getTemperature();
   oled.print("T: " + String(t));
   oled.print(" C");


   // get and display humidity
   float h = getHumidity();
   oled.print(" H: "+ String(h)+" ");
   oled.print("%  ");


   // Get data from light sensor
    Tsl.on();
    Tsl.setSensitivity(true, Tsl2561::EXP_14);
    delay(16);
    uint8_t id;
    uint16_t full, ir;
    Tsl.id(id);
    Tsl.fullLuminosity(full);
    Tsl.irLuminosity(ir);

    Tsl.off();
    // Print light sensor data to the display
    oled.println(" ");
    oled.print(format("Light %5u /%5u",  full, ir));

    oled.print("\n");


   ///////////////COMPLETE THE CODE///////////////////////



  /////////////////////////////////////////////////////////////
   oled.print("Button pressed "+String(button_press)+" times");
   delay(1000);

   delay(frequency);


}
