// Add these libraries
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include <Tsl2561.h> //from Joba
#include <Sodaq_SHT2x.h>
#include "mma8652.h" //from panStamp

// I2C address of Oled screen
#define I2C_ADDRESS 0x3C

// Initialize OLED screen
SSD1306AsciiWire oled;

// Define proper RST_PIN if required.
#define RST_PIN -1


#define SAMPLE_FREQ 1 //(in Hz)

int loop_time=1/SAMPLE_FREQ*1000; //Time for sampling in milliseconds

// Get temperature from temperature sensor
float getTemperature()
{
   float t = SHT2x.GetTemperature();
   //Serial.print(" Temperature(C): ");
   //rial.println(t);
   return t;
}



void setup() {
  // put your setup code here, to run once:
  // Initialize I2C communication
  Wire.begin();
  Wire.setClock(400000L);


  // Initialize serial line for communication with computer
  Serial.begin(115200);
  // Initialize serial line for communication with Xbee
  // Works only on MEGA boards, since UNO only has one serial line
  Serial3.begin(9600);

  //Change Arduino PAN ID (Used in the lab to ensure that people do not broadcast to their neighbours)
   // Flush serial line
   Serial3.flush();
    delay(1500);
    //Activate AT command mode
    Serial3.print("+++");
    Serial3.flush();
    delay(1500);
    // Change ID (can be any number between 0 and 0xFFFF)
    // In the lab, i will ask the students to use the number of their computer as ID
    // All devices that should communicate must have the same PAN ID
    Serial3.print("ATID 2019\r");
    Serial3.print("ATCN\r"); //ExitCommandmode

    //clear serial buffer
  //while(Serial3.available()){Serial3.read();}

   //Initialize the screen
#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();
   

}

void loop() {
  // put your main code here, to run repeatedly:

   oled.home();
   oled.set1X();
   

  float t = getTemperature();
  Serial3.println(t);
  Serial.println(t);

  delay(loop_time);

  oled.print("TRANSMITTER");

}
