// Lab 5 software for Arduino shield board AXB02 from EPFL Disal
// with Disaplay 128x32 SSD1306, Temperature sensor SHT2x and 
// light sensor TSL2561.
// Battery voltage reading
// Tested Arduino board: UNO, MEGA
// C. Ercolani 10-4-2019
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
int incomingData=0;

// I2C address of Oled screen
#define I2C_ADDRESS 0x3C

// Initialize OLED screen
SSD1306AsciiWire oled;

// Define proper RST_PIN if required.
#define RST_PIN -1


void setup() {
  Wire.begin();
  Wire.setClock(400000L);
   
  //Initialize serial line to communicate with the computer
  Serial.begin(9600);
  while(!Serial){
 
  }

  //Initialize serial line to communicate with the Xbee
  Serial3.begin(9600);

  //Change Arduino PAN ID (Used in the lab to ensure that people do not broadcast to their neighbours)
   // Flush serial line
   Serial3.flush();
    delay(1500);
    //Activate AT command mode
    Serial3.print("+++");
    Serial3.flush();
    delay(1500);
    // Change ID (can be any number between 0 and 0xFFFF)
    // Substitute the number 2019 with the number of your computer in the computer room. This will allow you to
    // create your unique network for wireless communication.
    Serial3.print("ATID 2019\r");
    Serial3.print("ATCN\r"); //ExitCommandmode
       //Initialize the screen
#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();


  //clear serial buffer
  while(Serial3.available()){Serial3.read();}

}

void loop() {
  oled.home();
  oled.set1X();
  oled.print("RECEIVER");
   
  // Read from Xbee serial line, write to computer Serial line
  while(Serial3.available() > 0)
  {
   Serial.write(Serial3.read());
  }

}
