import serial
import os

arduino_port = "/dev/ttyUSB0" #serial port of Arduino
baud = 9600 #arduino MEGA runs at 9600 baud
fileName="temp_data.txt" #name of the CSV file generated

# Get full path to the file
script_dir = os.path.dirname(os.path.abspath(__file__))
file_path = os.path.join(script_dir, fileName)

ser = serial.Serial(arduino_port, baud)
print("Connected to Arduino port:" + arduino_port)

with open(file_path, "w") as file:
    print("Created file")

    samples = 10
    line = 1
    #discard first 10 samples
    discard=10
    print("Discarding initial samples")
    while line <= discard:
        line = line+1
        
    line=1
    while line <= samples:
        data=ser.readline()
        s=data.decode('UTF-8')
        print(s)
        file.write(s)
        line = line+1

print("Data collection complete!")
file.close()
