// Lab 5 software for Arduino shield board AXB02 from EPFL Disal
// with Disaplay 128x32 SSD1306, Temperature sensor SHT2x and 
// light sensor TSL2561.
// Battery voltage reading
// Tested Arduino board: UNO, MEGA
// E.Droz, C. Ercolani 5-4-2019


// Add these libraries
#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"
#include <Tsl2561.h> //from Joba
#include <Sodaq_SHT2x.h>
#include "mma8652.h" //from panStamp



// Initialize light sensor 
Tsl2561 Tsl(Wire);

// Initialize OLED screen
SSD1306AsciiWire oled;

// I2C address of Oled screen
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1

// Define the time interval for sampling (in milliseconds)
#define SAMPLE_TIME 1000


//------------------------------------------------------------------------------


// to mimic Serial.printf() of esp8266 core for other platforms
char *format( const char *fmt, ... ) {
  static char buf[128];
  va_list arg;
  va_start(arg, fmt);
  vsnprintf(buf, sizeof(buf), fmt, arg);
  buf[sizeof(buf)-1] = '\0';
  va_end(arg);
  return buf;
}



void setup() {
  // Initialize I2C communication
  Wire.begin();
  Wire.setClock(400000L);

  // Initialize serial line for communication with computer
  Serial.begin(9600);


 //Initialize the screen
#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();

   
}

//------------------------------------------------------------------------------
void loop() 
{

   uint32_t m = millis();
   
   oled.home();
   oled.set1X();
   
   delay(5);  

   

   // Get data from light sensor
   Tsl.begin();
   if( Tsl.available() ) 
   {
      Tsl.on();
      Tsl.setSensitivity(true, Tsl2561::EXP_14);
      delay(16);

      uint8_t id;
      uint16_t full, ir;

      Tsl.id(id);
      Tsl.fullLuminosity(full);
      Tsl.irLuminosity(ir);


      // print light sensor data to the serial port connected to the computer
      //Serial.print(format("Tsl2561 (full / ir) = %5u /%5u\n",  full, ir));
      Serial.print(full);
      Serial.print(",");
      Serial.println(ir);

      
      //////// ADD YOUR CODE HERE////////
      // Check if light has undesired values
      // Print warning 

      ///////////////////////////////////

      Tsl.off();
      // Print light sensor data to the display
      oled.println(" ");
      oled.print(format("Light: %5u /%5u",  full, ir));
  }
  else 
  {
    Serial.println("No Tsl2561 found. Check wiring.");
  }

  delay(SAMPLE_TIME);
}
