// Hello world for Arduino shield board AXB02 from EPFL Disal
// with Disaplay 128x32 SSD1306, Temperature sensor SHT2x and 
// light sensor TSL2561.
// Battery voltage reading
// Tested Arduino board: UNO, MEGA
// E. Droz, C. Ercolani 5-4-19




#include <Wire.h>

//////////////////// Add these libraries /////////////
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h" // This library should be contained in the one above
#include <Tsl2561.h> //from Joba
#include <Sodaq_SHT2x.h>
#include "mma8652.h" //from panStamp
//////////////////////////////////////////////////////

//BUTTONS
#define BTN_BACK 13 
#define BTN_OK 12
#define BTN_FWD 9



// Initialize OLED screen
SSD1306AsciiWire oled;

// I2C address of Oled screen
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1


// to mimic Serial.printf() of esp8266 core for other platforms
char *format( const char *fmt, ... ) {
  static char buf[128];
  va_list arg;
  va_start(arg, fmt);
  vsnprintf(buf, sizeof(buf), fmt, arg);
  buf[sizeof(buf)-1] = '\0';
  va_end(arg);
  return buf;
}


void setup() {
  // Initialize I2C communication
  Wire.begin();
  Wire.setClock(400000L);

  // Initialize serial line for communication with computer
  Serial.begin(9600);

  // Initialize GPIO to control the buttons
  pinMode(BTN_BACK,INPUT_PULLUP);
  pinMode(BTN_OK,  INPUT_PULLUP);
  pinMode(BTN_FWD, INPUT_PULLUP);



 //Initialize the screen
#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();

   
}

//------------------------------------------------------------------------------
void loop() 
{

   uint32_t m = millis();
   
   oled.home();
   oled.set1X();
   
   delay(10);


   oled.print("Hello world!\n");
    

   // Read status of buttons
   String line1 = " ";
   if (digitalRead(BTN_BACK) == false)
   {
      line1 += "Welcome";
   }
   else 
      line1 += "-------";
    // display status of button   
   oled.print(line1);
    oled.print("\n");

   String line2 = " ";
   if (digitalRead(BTN_OK) == false)
   {
      line2 += "to";
   }
   else 
      line2 += "--";
    // display status of button   
   oled.print(line2);
    oled.print("\n");


    String line3 = " ";
   if (digitalRead(BTN_FWD) == false)
   {
      line3 += "Lab 5";
   }
   else 
      line3 += "------";   

   // display status of button   
   oled.print(line3);
   
  oled.print("\n");


  //Print something to Serial line
  Serial.println("Hello world!!");
  
}
