// Demo soft for Arduino shield board AXB02 from EPFL Disal
// with Disaplay 128x32 SSD1306, Temperature sensor SHT2x and 
// light sensor TSL2561.
// Battery voltage reading
// Tested Arduino board: UNO
// E.Droz jan 2019


#include <Wire.h>
#include "SSD1306Ascii.h"
#include "SSD1306AsciiWire.h"


int ResolutionBits = 10;   //Resolution set


// 0X3C+SA0 - 0x3C or 0x3D
#define I2C_ADDRESS 0x3C

// Define proper RST_PIN if required.
#define RST_PIN -1

SSD1306AsciiWire oled;
//------------------------------------------------------------------------------


// to mimic Serial.printf() of esp8266 core for other platforms
char *format( const char *fmt, ... ) {
  static char buf[128];
  va_list arg;
  va_start(arg, fmt);
  vsnprintf(buf, sizeof(buf), fmt, arg);
  buf[sizeof(buf)-1] = '\0';
  va_end(arg);
  return buf;
}


void setup() {
  Wire.begin();
  Wire.setClock(400000L);
  Serial.begin(115200);

#if RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS, RST_PIN);
#else // RST_PIN >= 0
  oled.begin(&Adafruit128x32, I2C_ADDRESS);
#endif // RST_PIN >= 0

   oled.setFont(Adafruit5x7);
   oled.displayRemap(1);
   oled.setContrast(0);

   oled.clear();
}
//------------------------------------------------------------------------------
void loop() 
{

   uint32_t m = millis();

   oled.home();
   oled.set1X();

   delay(100);  

  #if defined (ARDUINO_AVR_MEGA2560 )
     analogReference(INTERNAL1V1);
  #else
     analogReference(INTERNAL);
  #endif
  
  unsigned int a0 = analogRead(A0);
  float VBatt = a0 * 1.1  /* mVref*/ * 4.0 /*Voltage divider*/ / 1023.0 * 0.9545 /*correction*/;
  Serial.println(String("Code=")+ String(a0) + String(" Batt voltage = ") + String(VBatt)+ " V");
  oled.print(String ("Battery Voltage ") + String (VBatt) + "V"); 
}
