function visualize_lowpass_coefficients(coeff)
    % Visualize the lowpass filter coefficients
    % coeff: lowpass filter coefficients b_k
    figure
    stem((0:length(coeff)-1), coeff, 'filled')
    title('Lowpass filter coefficients');
    xlabel('$k$','Interpreter','latex');
    ylabel('$b_k$','Interpreter','latex');

    % flip x-axis
    set(gca,'XDir','reverse')

    % Add a label in the top-left of the figure with the FIR filter equation
    annotation('textbox', [0.14, 0.8, 0.1, 0.1], 'String', 'FIR filter: $y[n] = \sum_{k=0}^M b_k x[n-k]$','Interpreter','latex','FitBoxToText','on');
end