function analyzeSoundSignal(y,fs)
%close all
figure
subplot(2,1,1);
dataFrequency = fs; 
samplingPeriod = 1/dataFrequency;
t = 0:samplingPeriod:(length(y)-1)*samplingPeriod;
plot(t,y)
title('Time domain');
xlabel('time [s]');

%Compute Fourier Transform and plot it
subplot(2,1,2);
fty=abs(fft(y)/length(y));
f=dataFrequency/2*linspace(0,1,round(length(y)/2));
fty=fty(1:length(f));
plot(f,fty);
%ylim([0 0.002])
xlabel('frequency [Hz]');
title('DFT');

