% Fill the gaps shown by ...
% Uncomment codes if necessary
% Execute each section(question) by pressing "Ctrl+Enter" in that section
% Each section might depend on previous sections, so execute them in order

clc
clear all
close all

%% Q2

% Define constants
R = 1;
C = 0.1; 
Gamma = R*C;

% Define symbolic variables and preferences(time, impulse response, output, input variables)
syms t h y u
sympref('HeavisideAtOrigin',1);

% Compute step function (input) symbolically (Use heaviside())
u = heaviside(t);
% Compute impulse response symbolically (Use expression for impulse response)
h = 1/Gamma*exp(-1/Gamma*t)*u;
% Compute step response (output) symbolically (Use expression for step response)
y = (-exp(-1/Gamma*t)+1)*u;

% Plot
figure
fplot(h,[0,0.6],'LineWidth',2)
xlabel('time (s)')
ylabel('amplitude')
grid on
hold on
fplot(y,[0,0.6],'LineWidth',2)
legend('impulse response','step response')
xlabel('time (s)')
ylabel('amplitude')

%% Q3

% Define additional symbolic variables (Convolution variable)
syms tau 

% Compute step input for convolution symbolically (Use heaviside)
u_conv = heaviside(tau);
% Compute impulse response for convolution symbolically (Use subs())
h_conv = subs(h,t-tau);
% Compute convolution symbolically (Use int())
conv = int(u_conv*h_conv,tau,-inf,inf);

% Plot
figure
fplot(conv,[0,0.6],'LineWidth',2)
grid on
legend('step response convolution')
xlabel('time (s)')
ylabel('amplitude')

%% Q4

%Define additional symbolic variables (Freq variable)
syms w 

% Compute Fourier transfom symbolically (Use fourier())
Y_FT = fourier(conv,t,w);

%Plot
figure
fplot(abs(Y_FT));
grid on
legend('Frequency content')
xlabel('Freq. (rad/s)')
ylabel('amplitude')

%% Q6, Q7

% Define additional symbolic variables (Laplace variable)
syms s

%(Q6)
% Compute Laplace transform of input symbolically (Use laplace()) 
U_LT = laplace(u,t,s);
% Compute Laplace Transform of impulse response symbolically (Use laplace())
H_LT = laplace(h,t,s);
% Compute step response in time domain symbolically (Use ilaplace())
y_2 = simplify(ilaplace(U_LT*H_LT,s));

% (Q7)
% Compute transfer function (Use tf()) 
H_LT_tf = tf(10,[1,10]);

figure
subplot(2,1,1)
fplot(y_2,[0,0.6],'LineWidth',2);
grid on
xlabel('time (s)')
ylabel('amplitude')
legend('Step response by Laplace Transform');
% Plot step response
subplot(2,1,2)
step(H_LT_tf,0.6);
grid on
legend('Step response by transfer function');









