% Script to reconstruct light sensor measurements taken with Webots
% EDM, 7 April 2014

function ReconstructionSignal
original_signal=load('ls_values.txt');
original_signal(original_signal(:,1)>10,:)=[];  % keep only 10 initial seconds
%original_signal=original_signal(1:4:end,:);     % get 1/4 of the orignal sampling frequency
t=original_signal(:,1);
y=original_signal(:,2);
y=y-mean(y);
fs=1/(t(2)-t(1));
fprintf('Sampling frequency fs = %.3f Hz\n',fs)

% Plot original signal
figure;
subplot(3,1,1);
stem(t,y);
xlabel('Time [s]');
title('Original signal');
grid on;
ylim([-500, 500])

% Reconstruct signal with desired method
reconstructFreq=1000;
tr=0:1/reconstructFreq:max(t);

% -------------------------------------------------------------------------
% TODO: choose reconstruction method
method = 'zoh'; % one of 'zoh', 'linear', 'ws'
% -------------------------------------------------------------------------

% Apply the selected method
if strcmp(method,'zoh')
    yr=zohSignalResonstruction(tr,t,y);
elseif strcmp(method,'linear')
    yr=linearSignalReconstruction(tr,t,y);
elseif strcmp(method,'ws')
    yr=wsSignalReconstruction(tr,t,y);
else
    error('Invalid reconstruction method selected')
end 

% Plot reconstructed signal
subplot(3,1,2);
plot(tr,yr);
grid on;
xlabel('Time [s]');
title(strcat('Reconstructed signal, method: ',method));
axis([0 max(tr) -500 500]);

% Plot FFT of reconstructed signal
subplot(3,1,3);
fty=abs(fft(yr)/length(yr));
f=reconstructFreq*(0:length(yr)/2)/length(yr);
fty=fty(1:length(f));
Fmax=20;
maxIndex=find(f>Fmax,1);
plot([-f(maxIndex:-1:2) f(1:maxIndex)], [fty(maxIndex:-1:2) fty(1:maxIndex)]);
xlabel('Frequency [Hz]');
title('FFT of reconstructed signal');
% yscale('log')
% ylabel('log(|F|)')
grid on;
ylim([0.01, 120])


%%%%%%%%%%%%%%%%%%%%%%%%%%
% Reconstruction methods %
%%%%%%%%%%%%%%%%%%%%%%%%%%

%Function to reconstruct the signal with zero-order hold 
function yr = zohSignalResonstruction(tr, ts, ys)
%tr     Resulting timeline
%ts     Sampled timeline
%ys     Sampled signal
if (length(tr) < 5 * length(ts))
    error('Reconstructed signal must have a frequency 5 times bigger than the sampling frequency');
end
yr = zeros(1, length(tr)); % reconstructed signal 
for k = 1:length(tr)
    % Find the index i such that ts(i) <= tr(k) < ts(i+1)
    i = find(ts <= tr(k), 1, 'last');
    % Check for boundary conditions
    if isempty(i)
        i = 1;
    elseif i == length(ts)
        i = length(ts) - 1;
    end
    % Zero-order hold interpolation
    yr(k) = ys(i);
end

%Function to reconstruct the signal with linear interpolation
function yr = linearSignalReconstruction(tr, ts, ys)
%tr     Resulting timeline
%ts     Sampled timeline
%ys     Sampled signal
if (length(tr) < 5 * length(ts))
    error('Reconstructed signal must have a frequency 5 times bigger than the sampling frequency');
end
% -------------------------------------------------------------------------
% TODO: Implement the reconstruction with linear interpolation and store
% the result in the variable yr. 
% Hint: you may take inspiration from the zero-order hold reconstruction
% above.

error('Linear reconstruction not implemented') % <- TODO: replace this with your implementation

% -------------------------------------------------------------------------

%Function to reconstruct the signal with Whittaker-Shannon
function yr=wsSignalReconstruction(tr,ts,ys)
%tr     Resulting timeline
%ts     Sampled timeline
%ys     Sampled signal
if(length(tr)<5*length(ts))
    error('Reconstructed signal must have a frequency 5 times bigger than the sampling frequency');
end
% -------------------------------------------------------------------------
% TODO: Implement the Whittaker-Shannon reconstruction and store
% the result in the variable yr. 

error('Whittaker-Shannon reconstruction not implemented') % <- TODO: replace this with your implementation

% -------------------------------------------------------------------------
