function analyzeLightSignal(logfile)
%close all
figure
subplot(2,1,1);
grid on;
samplingPeriod = 0.010; % Sampling Period: change this value to match the sampling period used in the Mica-Z mote
dataFrequency = 1/samplingPeriod;
rawData = load(logfile);
rawData = rawData(:,2:3);
y = rawData(:,2);
t = samplingPeriod*rawData(:,1);
t=t-t(1);
plot(t,y)
title('Time domain');
xlabel('time [s]');

%Compute Fourier Transform and plot it
subplot(2,1,2);
grid on;
fty=abs(fft(y)/length(y));
f=dataFrequency/2*linspace(0,1,round(length(y)/2));
fty=fty(1:length(f));
plot(f,fty);
xlim([0 2])
xlabel('frequency [Hz]');
title('DFT');

