clear all, close all, clc

% ######################################
% Parameters to change.
% Frequency is in Hz.
F = 19;  % Sine wave frequency (default: 19 Hz)
A = 1;   % Signal amplitude 
Fs = 50; % Sampling frequency (default: 50 Hz)

% ######################################


% Generate sampled signal

t = -500:1/Fs:500;
t = t + 0.00001*rand(1,length(t));
y_sampled = A*sin(2*pi*F*t);
[freq, fft_sampled] = compute_fft(y_sampled, Fs);

% Generate real (High freq sampled) signal
Fs_hifreq = F*5;
t_hifreq = -500:1/Fs_hifreq:500;
%t_hifreq = t_hifreq + 0.00001*rand(1,length(t_hifreq));
y_hifreq = A*sin(2*pi*F*t_hifreq);
[freq_hifreq, fft_hifreq] = compute_fft(y_hifreq, Fs_hifreq);

% Plot
figure, 
subplot(2,1,1)
plot(freq_hifreq, fft_hifreq);
xlabel('Frequency [Hz]');
xlim([-1, max([freq, F])+1]);
title('True FFT')
grid on;

subplot(2,1,2)
plot(freq, fft_sampled);
xlabel('Frequency [Hz]');
xlim([-1, max(freq)+1]);
title('FFT of sampled signal')
grid on;



