function [  ] = plot_fourier(F)
% PLOT_FOURIER plots the fourier transform of a symbolic function.
% It has been tuned for the Signals, Instruments and Systems course
% F is the symbolic fourier transformof a function
% Plots diracs as well

% 11.03.2016, Steven Roelofsen
% Modified 19.03.2018, AQ
% Modified 12.03.2012 CE

str_F = char(F); % convert sym to char

str_dirac = strfind(str_F, 'dirac');  % look for diracs

str_par = strfind(str_F, ')'); % look for paretheses

t = [];

for n_dirac = 1:length(str_dirac);

    [val_par, ind_par] = (sort(-str_dirac(n_dirac) + str_par)); % search for the parethensis associated with the dirac

    ind_par = ind_par(val_par>0);

    str_point = str_F(str_dirac(n_dirac)+6:str_par(ind_par(1))-1); % get what is inside the dirac

    Fp = str2sym(str_point); % change it into a sym

    w = 0;

    t(end+1) = eval(Fp); % evaluate dirac's location

end

% construct sampling that contains dirac locations

if isempty(t)
    w_L = -40;
    w_H = 40;
    w = [w_L:0.01:w_H ];
% Added elseif to make S11
elseif length(t)==2 & t==[0,0]
    w_L = -40;
    w_H = 40;
    w = [w_L:0.01:w_H ];
elseif length(t) ==1
    w_L = t - 10;
    w_H = t + 10; 
    w = [w_L:0.01:w_H ];
else
    t = sort(t);
    w_L = min(t) - 0.4*abs(min(t));
    w_H = max(t) + 0.4*abs(max(t));
    
    step_w = 0.01;
    w = [w_L:step_w:t(1)-step_w];
    for k = 1:length(t)-1
        w = [w t(k):step_w:t(k+1)-step_w];
    end
    w = [w t(end):step_w:w_H];
end 

val_F = eval(F);

magn = min(abs(val_F), 10); % clip inf to 10

ind_nan = isnan(abs(val_F));

magn(ind_nan) = nan; % leave nan as nan


subplot(2, 1, 1)

plot(w/(2*pi), magn)

title('Magnitude')

ylim([-0.1, 2])

grid on

subplot(2, 1, 2)

plot(w/(2*pi), angle(val_F))

title('Phase')

ax = gca;

ax.YTick = [-pi, -pi/2, 0, pi/2, pi];

ax.YTickLabel = {'-\pi','-\pi/2','0','\pi/2','\pi'};

ylim([-pi - 1, pi + 1])

xlabel('frequency [Hz]');

grid on

drawnow

% keyboard


end

