function display(a)
% @MOVIEAUDIO/DISPLAY Command window display of a movie audio object

% Author(s): Greg Krudysz

if isempty(a.recorder)
    recorder = '';
else
    recorder = sprintf(...
        '\n\t\t\t BitsPerSample: %d \n\t\t\t  TotalSamples: %d\n\t\t\t\t   Running: %s \n\t\t\t CurrentSample: %d',...
        get(a.recorder,'BitsPerSample'), ...
        get(a.recorder,'TotalSamples'), ...
        get(a.recorder,'Running'), ...
        get(a.recorder,'CurrentSample'));
end

if isempty(a.player)
    player = '';
else
    player = sprintf(...
        '\n\t\t\t BitsPerSample: %d \n\t\t\t  TotalSamples: %d\n\t\t\t\t   Running: %s \n\t\t\t CurrentSample: %d',...
        get(a.player,'BitsPerSample'), ...
        get(a.player,'TotalSamples'), ...
        get(a.player,'Running'), ...
        get(a.player,'CurrentSample'));
end

stg = sprintf(...
    '\t\t Fs: %d \n   recorder: %s \n\t player: %s',...
    a.Fs,recorder,player);
disp(stg)