#include <stdio.h>
#include "sensors.h"

/*************************************
// Part 2 : Compilation and Functions
 *************************************/

int main(int argc,char *args[])
{
  FILE *fp;
  int tm;
  float temp;
  char file_line[100];

  //check arguments
  if ( (argc != 2) ){
    fprintf(stderr, "Usage: %s [input file]\n", args[0]);
    return -1;
  }

  //open the file containing sensor messages
  fp = fopen(args[1], "r");
  // if the program failed to open the file, it will quit the main
  if (!fp) return -2;

  //get and process sensor messages
  //the message.txt is read line by line. The current line is saved inside 
  //the variable "file_name"
  while (fscanf(fp,"%s",file_line) == 1) {

    //get sensor time and its temperature reading
    tm 		= get_sensor_time(file_line);
    temp 	= get_sensor_value(file_line);

    //TODO: print the result and remove the default printf message
    /********************************
     * replace with your code here for the point 7*
     ********************************/
    printf("Message received but print not implemented yet!! format should be: at time <time> sensor sent temperature value of <temperature_reading>\n");

    //TODO: check the temperature and issue an alarm if it is above 35 degree. (call check_temp)
    /********************************
     * complete with your code here for the point 8*
     ********************************/
  }

  //close the file
  fclose(fp);

  return 0;
}
