#include <stdio.h>
#include <sys/time.h>
#include <stdlib.h>
#include <time.h>

#define M 250

/* Gets current time in microsecond precision */
double gettime()
{
  struct timeval time;

  gettimeofday(&time, NULL);
  return (double)time.tv_sec + ((double)time.tv_usec)/1000000.0;
}

int main()
{
  double start_time, end_time;
  double A[M][M];
  double B[M][M];
  double P[M][M];
  int i, j, k;
  double sum;

  // Initialize the matrix with random values
  srand(time(NULL));
  for (i = 0; i < M; i++) {
    for (j = 0; j < M; j++) {
      A[i][j] = (double)rand()/(double)RAND_MAX;
      B[i][j] = (double)rand()/(double)RAND_MAX;
    }
  }

  start_time = gettime();

  /*******************************************************
   * here is the code for multiplying two matrices:
   *******************************************************/
  sum = 0;
  for (i = 0; i < M; i++) {  
      for (j = 0; j < M; j++) {  
        for (k = 0; k < M; k++) {
      	    sum = sum + A[i][k]*B[k][j];
        } 
        P[i][j] = sum;
        sum = 0;
      }
  }


  end_time = gettime();
  printf("It took %.3f seconds to compute the multiplication.\n", end_time - start_time);
 
  return 0;
}
