# moyenne pondérée avec variance minimale
# Trois personnes aux compétences variées mesurent la 
# Certaines mesures sont corrélées.
# eso Oct. 24

import numpy as np
import matplotlib.pyplot as plt


# mesures
a = 2.82  # bar - apprenti-e
b = 2.74  # bar - garagiste
c = 2.63  # bar - expert-e
obs = np.array([a, b, c])
n = len(obs)

# écart-types
sigmaa = 0.10  # bar - apprenti-e
sigmab = 0.07  # bar - garagist-e
sigmac = 0.05  # bar - expert-e
sigma = np.array([sigmaa, sigmab, sigmac])

# choix de l'écart-type associé à l'unité de poids
sigma0 = np.median(sigma)  # pour obtenir des cofacteurs proches de 1 
q = sigma / sigma0  # écarts-types relatifs
Qll = np.diag(q * q) # éléments invariants de la matrice de cofacteurs

# variation de la corrélation entre a et b
maxi = 99  # nombre de pas
deltarho = 2 / (maxi + 1)  # longuer de pas

rhoab = np.zeros(maxi)
moy = np.zeros(maxi)
sigmamoy = np.zeros(maxi)


# réservation d'espace contigu
A = np.array([[1, 1, 1]]).T
u = 1

for i in range(maxi):
    rhoab[i] = -1 + (i+1) * deltarho

    # Variable elements of the cofactor matrix
    Qll[0, 1] = q[0] * q[1] * rhoab[i]
    Qll[1, 0] = Qll[0, 1]

# On calcule la moyenne pondérée avec une variance minimum en tenant compte 
# des corrélations. Les formules et le code correspondant ne font pas
# partie du cours.

# Le graphique issu du programme illustre quelques réflexions.

# Vers gauche ... Si la corrélation entre les mesures de l'apprentie et de la 
# garagiste approche -1, l'estimation se situe entre leurs mesures et son 
# écart-type est très faible.
# explication ... Puisque les erreurs de l'apprentie et du garagiste se
# compensent, leur moyenne (pondérée) devrait être exacte et la mesure de 
# l'experte est ignorée.

# au milieu ... Pour une corrélation comprise entre -0.5 et +0.5, 
# l'effet est modéré.

# Vers droite ... Si la corrélation entre les mesures de l'apprentie et de la 
# garagiste approche +1, l'estimation est proche de la mesure de l'experte 
# et son écart-type grandit.
# explication ... Puisque les erreurs de l'apprentie et de la garagiste
# sont semblables, l'influence de leurs mesures diminue et la mesure de 
# l'expert domine largement. Pour autant, elle n'est pas parfaite.

# Ceci rappelle la précaution élémentaire des journalistes lorsque deux 
# sources d'informations sont:
# - systématiquement contradictoires,
# - raisonnablement indépendantes,
# - des soeurs jumelles.