# -*- coding: utf-8 -*-
"""
auteur: ESO/ 25.09.24

Résumer une matrice de covariance avec un vecteur d'écarts-types et un
vecteur de corrélations en pourcents.
"""

import numpy as np

def covmat2corvec(Kll):

    n = np.size(Kll, axis=0)            # nombre de lignes
    sigma = np.zeros(n)                 # Réserver un espace contigu en mémoire.
    correl = np.zeros(int(n*(n-1)/2))   # idem

    k = 0   # compteur des éléments du vecteur des corrélations
    for i in range(n):
        sigma[i] = np.sqrt(Kll[i,i])

        # On considère le triangle inférieur de la matrice. Ainsi
        # on reste à gauche de la diagonale et une boucle "i" suffit.
        # Pour i=0 (1e ligne), la boucle "j" est ignorée;
        # pour i=1 (2e ligne), elle tourne une fois, et ainsi de suite.

        for j in range(i):
            correl[k] = 100.0*Kll[i,j]/(sigma[i]*sigma[j])
            k += 1   # k = k+1

    return sigma, correl
