# -*- coding: utf-8 -*-
"""
auteur: ESO / 25.09.24

A partir d'un vecteur d'écarts-types et d'un vecteur de corrélations en
pourcents, construire une matrice de covariance.
"""

import numpy as np

def corvec2covmat(sigma,correl):
    
    n = np.size(sigma)   # nombre d'éléments
    Kll = np.zeros((n,n))
    
    k = 0   # compteur pour le vecteur des corrélations
    for i in range(n):
        Kll[i,i] = sigma[i]*sigma[i]
        for j in range(i):   # triangle inférieur de la matrice
            Kll[i,j] = sigma[i]*sigma[j]*correl[k]/100.0
            Kll[j,i] = Kll[i,j]
            k += 1   # k = k+1
            
    return Kll

