# -*- coding: utf-8 -*-
"""
auteur: ESO / 25.09.23

A partir d'une matrice de covariance, former un vecteur d'écarts-types et
une matrice de corrélation.
"""

import numpy as np

def covmat2cormat(Kll):
    
    n = np.size(Kll, axis=0)   # nombre de lignes
    sigma = np.zeros(n)        # Réserver un espace contigu en mémoire.
    Rll = np.zeros((n,n))      # idem

    for i in range(n):
        sigma[i] = np.sqrt(Kll[i,i])
        Rll[i,i] = 1
        for j in range(i):     # triangle inférieur de la matrice
            Rll[i,j] = Kll[i,j]/sigma[i]/sigma[j]
            Rll[j,i] = Rll[i,j]
       
    return sigma, Rll

