# -*- coding: utf-8 -*-
"""
auteur: ESO 14.10.24
"""

"""
Méthodes d'estimation - Exercice 3.2 "Triglav"
Construire une matrice de covariance.
"""

print("\n",'########### exercice "Triglav" ###########')

import numpy as np


###########################################################
################ Déclarer les observations. ###############
y = np.array([150.0,100,150,100])     # distances ver C, in [m]
dt = 4.0                              # temps des observations, en min 
b = 0.5                                # const. imprecission, en cm
q = 0.02/100.0                         # constante en % 
sigmay = (y * q + b/100.0)*100         # écarts-types, en cm 
# sigmay = np.divide(q,y) convient aussi

###########################################################
########### Calculer la matrice de corrélation. ###########

n = np.size(y)
Ryy = np.ones((n,n))           # Réserver un espace contigu en mémoire.
for i in range(n-2):
    #Ryy[i,i] = 1               # Remplir la diagonale.
    for j in range(n-2):          # pour le triangle inférieur de la matrice
        Ryy[i,j+2] = 1/(dt/2+1)
        Ryy[i+2,j] = Ryy[i,j+2]  # Remplir le le rest.

###########################################################
############ Calculer la matrice de covariance. ###########

# Importer la fonction définie dans cormat2covmat.py.
from cormat2covmat import cormat2covmat
Kyy = cormat2covmat(sigmay,Ryy)


###########################################################
# Afficher les écarts-types, corrélations et covariances. #
np.set_printoptions(precision=2)
print("\n","vecteur des écarts-types","\n",sigmay)
print("\n","matrice de corrélation","\n",Ryy)
print("\n","matrice de corrélation en pourcents","\n",np.rint(Ryy*100.0))
#print("\n","matrice de corrélation en pourcents","\n",(Ryy*100.0))
print("\n","matrice de covariance","\n",Kyy)

"""
Méthodes d'estimation - Exercice 3.3 "kovac"
Démonter et reconstruire la matrice de covariance Kll issue de l'exercice 
précédent "cerceau".
"""

print("\n",'########### exercice "Kovac" ###########')
print("\n",'Extraire les vecteurs sigma et correl.')

# Importer la fonction définie dans covmat2corvec.py.
from covmat2corvec import covmat2corvec
sigma,correl = covmat2corvec(Kyy)

print("\n","sigma = vecteur des écarts-types","\n",sigma)
print("\n","correl = vecteur des corrélations","\n",correl)

print("\n","Reconstruire la matrice de covariance.")

# Importer la fonction définie dans corvec2covmat.py.
from corvec2covmat import corvec2covmat
Kyybis = corvec2covmat(sigma,correl)

print("\n","matrice de covariance reconstruite","\n",Kyybis)

# La matrice reconstruite peut différer légérement de la matrice
# originale si on a arrondi les corrélations à des pourcents entiers.