clc;
close all;
clear all;
%%
n       =   4;
m       =   1;
% set parameter values
x0      =   [20*pi/180; 0; 1.5; 0];
% x_term  =   [22*pi/180; 0; 1.5];
umax    =   1*1000;
umin    =   -umax;
lmax    =   x0(3);


t0      =   0;
dt      =   0.025;
N       =   50;
Tf      =   2.0; N*dt;
tmpc    =   0:dt:Tf;



%% set up OCP -- periodic reference
display('Constructing NLP ...')
import casadi.*
X       =   optivar(n,N+1);
U       =   optivar(m,N);
xInit   =   optipar(n,1,'xInit'); % CasADi parameter
g       =   [];
J       =   0;

ref     =   23*pi/180*cos(sqrt(9.81/lmax)*tmpc+0.2);
Q1      =   1e5;
R       =   0.1;

for k=1:N
    xx      =   rk4(@(s,z,v)Swing_ODE_NMPC(s,z,v),dt,tmpc(1),X(:,k),U(:,k));
    g       =   [g, {X(:,k+1)==xx}];
    g       =   [g, {0.9*lmax <= X(3,k+1) <= lmax}];
    g       =   [g, {umin <= U(:,k) <= umax}];
    dx      =   X(1,k+1) - 23*pi/180*cos(sqrt(9.81/lmax)*X(4,k+1)+0.2);
    J       =   J + ( dx'*Q1*dx + U(:,k)'*R*U(:,k) )*dt;
end
    g   =   [g, { X(:,1) == xInit}];

%     hold on;

%% solve NMPC loop

xMPC = [x0];
uMPC = [];
xk = x0;
for  i = 1:length(tmpc)
    
    U.setInit(repmat(0,1,N));
    X.setInit(repmat(x0,1,N+1));
    %% solve open-loop problem
    if i ==1
        U.setInit(repmat(0,1,N));
        X.setInit(repmat(x0,1,N+1));
        xInit.setValue(xk);
        sol_k     =   optisolve(J,g);
    else
        U.setInit(usol_k);
        X.setInit(xsol_k);
        xInit.setValue(xk);
        sol_k.resolve();
    end
    
    xsol_k    =   optival(X);
    usol_k    =   optival(U);
    
    xk = xsol_k(:,2);
    uk = usol_k(:,1);
    
    xMPC = [xMPC, xk];
    uMPC = [uMPC, uk];
  
end

figure(4)
    plot(tmpc,xMPC(1:2,1:end-1)');
    xlabel('$t$','interpreter','latex');
    ylabel('$\varphi(t), \dot{\varphi}(t)$','interpreter','latex');
    grid on;
    hold on;
    plot(tmpc,ref);

    figure(5)
    plot(tmpc,xMPC(3,1:end-1))
    xlabel('$t$','interpreter','latex');
    ylabel('$\ell(t)$','interpreter','latex');
    grid on;
    hold on;

    figure(6)
    plot(tmpc,uMPC)
    xlabel('$t$','interpreter','latex');
    ylabel('$u(t)$','interpreter','latex');
    grid on;
%     hold on;
    


