%% Optimal Control Course EE 715 at EPFL
% Problem Set #3 Exercise 1 b c
%
% Author(s):    tillmann.muehlpfordt@kit.edu, alexander.engelmann@kit.edu, timm.faulwasser@kit.edu
% Date:         April 10, 2017
%% initialize
clear all;
close all;
clc;
set(groot, 'defaultAxesTickLabelInterpreter','latex');
set(groot, 'defaultLegendInterpreter','latex');

import casadi.*
%% parameters
t0   =  0;  % initial time
tf   =  1;  % end time (scaled to [0,1])
N    =  100; % number of dsicretization steps on the horizon length
dt   =  (tf-t0)/N;
t    =  t0:dt:tf;
nx   =  2;
nu   =  1;
% initial conditions
cA0 =   0.25; 
T0  =   370;
x0  =   [cA0; T0];

% constraints
umin    =   270.0;
umax    =   330.0;
%% solve steady state problem
% steady state
xSS = [0.159, 374.9854]';
uSS = [302.8];


%% define free endtime OCP
opti = casadi.Opti();

X       =   opti.variable(nx,N+1);
U       =   opti.variable(nu,N);
tf      =   opti.variable(1,1);
J       =   0; 

for i=1:N
    u = [U(:,i),tf];
    xx      =   rk4(@(t,x,u)CSTR_ode_mod(t,x,u),dt,t(i),X(:,i),u);
    opti.subject_to(X(:,i+1)-xx == 0);
end

J = tf^2; %J + dxdt_end'*dxdt_end;
% initial condition
opti.subject_to(X(:,1) == x0); 

% terminal constraint
 opti.subject_to(X(:,end) == xSS);

% input box constraint
opti.subject_to(U >= umin);
opti.subject_to(U <= umax);
opti.subject_to(tf <= 10);

%% solve OCP
% initial guess
opti.set_initial(tf, 1);
opti.set_initial(X, x0+zeros(nx, N+1));
opti.set_initial(U, 0.5*(umax-umin)+zeros(nu, N));

% solve ocp
opti.minimize(J);

opti.solver('ipopt');
tic
sol = opti.solve();

% get solution
Xsol    =   sol.value(X);
Usol    =   sol.value(U);
tfsol   =   sol.value(tf);

% rescale time
t = t.*tfsol;
%% plot
figure(1)
subplot(2,2,1)
plot(t,Xsol(1,:));
grid on;
xlabel('$t$ [min]','interpreter','Latex');
ylabel('$c_A(t)$ [mol/l]','interpreter','Latex');
subplot(2,2,2)
plot(t,Xsol(2,:));
grid on;
xlabel('$t$ [min]','interpreter','Latex');
ylabel('$T(t)$ [K]','interpreter','Latex');
subplot(2,2,3)
plot(t(1:end-1),Usol);
grid on
xlabel('$t$ [min]','interpreter','Latex');
ylabel('$u^\star(t)$ [K]','interpreter','Latex');



