function P2EX2_a_sol
%% Optimal Control (EE-715)
% Course at EPFL
% Problem Set #1 Exercise 8 Task a
%
%
% Autor:    timm.faulwasser@kit.edu
% Date:     20-07-16
% Status:   final

clc
close all
clear all

%options = optimoptions('fmincon');
options = optimset; %('fmincon');
options.TolFun =  1E-7; 
options.TolCon =  1E-7; 
options.TolX   =  1E-7;
options.Algorithm  = 'sqp';
options.GradConstr = 'off';
options.GradObj    = 'off';
options.Display    = 'iter';

x_guess = [1 1 1];

%linear constraints
A_ineq = [-1, 2, 1];
b_ineq = 3;

A_eq = [];
b_eq = [];

lb = [0, 0, 0]';
ub = [];

[xopt,fval,exitflag,output,lambda,grad,hessian] =fmincon(@objective,... %reference to the cost function
                                                    x_guess,...   %initial guess
                                                    A_ineq,...    %A from inequality constraints Au<=B
                                                    b_ineq,...    %B from inequality constraints Au<=B
                                                    A_eq,...      %A from equality constraints Au=B
                                                    b_eq,...      %B from equality constraints Au=B
                                                    lb,...        %lower bound for u (LB<=u<=UB)
                                                    ub,...        %upper bound for u (LB<=u<=UB)
                                                    @constr, options)  %function defining the equality/inequality constraints


%% supplying gradient information to the solver

options.GradConstr = 'on';
options.GradObj = 'on'; 
options.DerivativeCheck = 'on';

[xopt,fval,exitflag,output,lambda,grad,hessian] =fmincon(@objective,... %reference to the cost function
                                                    x_guess,...   %initial guess
                                                    A_ineq,...    %A from inequality constraints Au<=B
                                                    b_ineq,...    %B from inequality constraints Au<=B
                                                    A_eq,...      %A from equality constraints Au=B
                                                    b_eq,...      %B from equality constraints Au=B
                                                    lb,...        %lower bound for u (LB<=u<=UB)
                                                    ub,...        %upper bound for u (LB<=u<=UB)
                                                    @constr, options)  %function defining the equality/inequality constraints
                                                
lambda.lower

keyboard
%% checking regularity
[gopt,hopt, grad_gopt, grad_hopt]=constr(xopt);
[fopt, grad_fopt] = objective(xopt);

Jacobian = [grad_gopt, A_ineq', [0;-1;0]];
rankJac = rank(Jacobian);
display(['The rank of the Jacobian of the active constraints is:  ', num2str(rankJac)]);

%% checking KKT conditions
for i =1:3
   KKT(i) =  grad_fopt(i) + lambda.ineqlin*A_ineq(i) +  lambda.ineqnonlin*grad_gopt(i) + lambda.lower(i)*(-1);
end

display(['The KKT conditions are satisfied up the following accuracies: ', num2str(KKT)])

end
%% define objective as subfunction
function [f, grad_f] = objective(x)
f = x(1)^2+x(1)*x(2)+2*x(2)^2-6*x(1)-2*x(2)-12*x(3);
grad_f = [2*x(1)+x(2)-6; x(1)+4*x(2)-2; -12];
end

%% define nonlinear constraints as subfunction
function [g,h, grad_g, grad_h]=constr(x)

g(1) = 2*x(1)^2+x(2)^2 -15;
h = [];
grad_g = [4*x(1); 2*x(2); 0];
grad_h = [];

end

