function PlotPhaseursEtTopogramme3Machines(block)
% % v02 : avec Axis Equal
% Input 1 = Angle phaseurs
% Input 2 = Amplitude des phaseurs Machine 2
% Input 3 = Phaseurs ou Topogramme
% Input 4 = P1
% Input 5 = Q1
% Input 6 = P2
% Input 7 = Q2
% Input 8 = Amplitude des phaseurs Machine 1 (grid)
% Input 9 = Angle phaseurs
% Input 10 = Amplitude des phaseurs Machine 3 
% Input 11 = P3
% Input 12 = Q3


% Call the setup function
setup(block);

%endfunction
function setup(block)

% exemple trouvé de garder le handle
%s = surf(peaks);
%set_param(block.BlockHandle,'UserData',s);

% Register number of ports
block.NumInputPorts  = 12;
block.NumOutputPorts = 0;

% Setup port properties to be inherited or dynamic
block.SetPreCompInpPortInfoToDynamic;
block.SetPreCompOutPortInfoToDynamic;

% Register the parameters.
block.NumDialogPrms     = 3;
%block.DialogPrmsTunable = {'Nontunable','Nontunable','Nontunable','Nontunable'};
  

% Register sample times
%  [0 offset]            : Continuous sample time
%  [positive_num offset] : Discrete sample time
%  [-1, 0]               : Inherited sample time
%  [-2, 0]               : Variable sample time
block.SampleTimes = [0.2 0]; % on rafraichi à 50Hz ...

% Specify the simStateCompliance to default
block.SimStateCompliance = 'DefaultSimState';

% Register all relevant methods
block.RegBlockMethod('Outputs', @Outputs);     % Required
block.RegBlockMethod('Terminate', @Terminate); % Required

% read parameters
xd = block.DialogPrm(1).Data;
xq = block.DialogPrm(2).Data;
coeff_If = block.DialogPrm(3).Data;

% autre exemple de garder le handle
%% Create UI

% lineH 1-2-3     : Phaseurs - Grid
% lineH 4-5-6     : Phaseurs - Machine 1
% lineH 7-8-9     : Phaseurs - Machine 2
% lineH 10-11-12  : Topogramme - P,Q 1 et 2 et 3
% lineH 13-14-15  : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
lineH = get_param(block.BlockHandle,'UserData');

if ishghandle(lineH)
    set(lineH(1),'XData', nan, 'YData',nan);
    set(lineH(2),'XData', nan, 'YData',nan);
    set(lineH(3),'XData', nan, 'YData',nan);
    set(lineH(4),'XData', nan, 'YData',nan);
    set(lineH(5),'XData', nan, 'YData',nan);
    set(lineH(6),'XData', nan, 'YData',nan);
    set(lineH(7),'XData', nan, 'YData',nan);
    set(lineH(8),'XData', nan, 'YData',nan);
    set(lineH(9),'XData', nan, 'YData',nan);
    set(lineH(10),'XData', nan, 'YData',nan);
    set(lineH(11),'XData', nan, 'YData',nan);
    set(lineH(12),'XData', nan, 'YData',nan);
else
    myLineWidthPhaseurs = 5; % taille des lignes
    myLineWidthTopogramme1 = 6;
    myLineWidthTopogramme2 = 6;
    mySizeTopogramme = 1.2; % per unit    
    mySizePhaseurs = 1.2;  % per unit
    figH = figure('Name',mfilename,'NumberTitle','off');
    set(figH, 'MenuBar', 'none');
    set(figH, 'ToolBar', 'none');
    tgH = uitabgroup(figH);
    tab1H = uitab(tgH, 'Title','Phaseurs');
    tab2H = uitab(tgH, 'Title','Topogramme');
    
    % PHASEURS -------------------------------------------------
    %ax1 = axes('Parent',figH);
    ax1 = axes(tab1H);
    axis(ax1,'off')
    hold(ax1,'on')
    
    % crée 9 line plot
    phaseursH = plot(ax1, 0, nan, 0, nan, 0, nan, 0, nan, 0, nan, 0, nan, ...
        0, nan, 0, nan, 0, nan, 'Tag','Phaseurs','LineWidth',myLineWidthPhaseurs);        
    axis(ax1,'off')
    axis(ax1,'equal')
    xline(ax1, 0);
    yline(ax1, 0);
    xlim(ax1, [-mySizePhaseurs mySizePhaseurs])
    ylim(ax1, [-mySizePhaseurs mySizePhaseurs])
    title(ax1,'Phaseurs');
    %xlabel('Time')
    %ylabel('Y')
    
    %colors
    set(phaseursH(1),'Color', 'blue');                 % bleu roi
    set(phaseursH(2),'Color', 'red');                  % rouge vif
    set(phaseursH(3),'Color', 'green');                % vert vif
    set(phaseursH(4),'Color', [0.3010 0.7450 0.9330]); % bleu clair
    set(phaseursH(5),'Color', [0.6350 0.0780 0.1840]); % rouge bordeaux
    set(phaseursH(6),'Color', [0.4660 0.6740 0.1880]); % vert pomme    
    set(phaseursH(7),'Color', [0.25 1 1]); % bleu plus clair
    set(phaseursH(8),'Color', [1 0.5 0.5]); % rouge bordeaux
    set(phaseursH(9),'Color', [0.5 1 0.5]); % vert plus pomme
    
    % cercle Un -> 1pu
    th = 0:pi/50:2*pi;
    xunit = cos(th);
    yunit = sin(th);
    hold(ax1, 'on');
    plot(ax1, xunit, yunit, 'k');
    
    % TOPOGRAMME -------------------------------------------------
    %ax2 = axes('Parent',figH);
    ax2 = axes(tab2H);
    title(ax2,'Topogramme');
    hold(ax2, 'on');
    
    topogrammeH = plot(ax2, 0, nan, 0, nan, 0, nan, 'Tag','Topogramme');
    % machine 1
    set(topogrammeH(1),'LineWidth',myLineWidthTopogramme1,'Marker','o');
    % machine 2
    set(topogrammeH(2),'LineWidth',myLineWidthTopogramme2,'Marker','o');
    % machine 3
    set(topogrammeH(3),'LineWidth',myLineWidthTopogramme2,'Marker','o');
    axis(ax2,'off');
    axis(ax2,'equal')
    xline(ax2, 0);
    yline(ax2, 0);
    xlim(ax2, [-mySizeTopogramme mySizeTopogramme]);
    ylim(ax2, [-mySizeTopogramme mySizeTopogramme]);
    title(ax2,'Topogramme');
    
    %xlabel('Time')
    %ylabel('Y')   
    
    % puissance mécanique
    yline(ax2, 0.85);
    yline(ax2, -0.85); %-0.85
    
    % cercle Sn -> 1pu
    th = 0:pi/50:2*pi;
    xunit = cos(th);
    yunit = sin(th);
    hold(ax2, 'on');
    plot(ax2, xunit, yunit, 'k');
    
    % cercle 1/xq 1/xq  
    r = (1/xq-1/xd)/2;
    xunit = r*cos(th)+(1/xd+r);
    yunit = r*sin(th);
    hold(ax2, 'on');
    plot(ax2, xunit, yunit, 'k');
    
    %limaçon de pascal pour le courant d'excitation
    th = -pi/4:pi/100:pi/4;
    b=(1/xq-1/xd);
    r = coeff_If + b*cos(th);
    [X,Y] = pol2cart(th, r);
    plot(ax2, -X+1/xq,Y,'k');    
    
    % limite stabilité statique
    coeff = 1;
    th = -coeff*pi/2:pi/100:coeff*pi/2;

    pstab = (1/xq-1/xd)*sin(th).^2./cos(th);
    [xstab,ystab] = pol2cart(th, pstab);
    
    plot(ax2, -xstab+1/xq,ystab,'k');   
    
    %ajoute légende à la fin sinon il mets les autres data
    legend(ax2,'MS1','MS2','MS3');
    
    % lineH 1-2-3     : Phaseurs - Grid
    % lineH 4-5-6     : Phaseurs - Machine 1
    % lineH 7-8-9     : Phaseurs - Machine 2
    % lineH 10-11-12  : Topogramme - P,Q 1 et 2 et 3
    % lineH 13-14-15  : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
    lineH = [phaseursH; topogrammeH; tgH; tab1H; tab2H];
    set_param(block.BlockHandle,'UserData',lineH);
end % END du if existe déjà ------------------------

%end setup

%% CreateUI
% Called to create the

%% Outputs:
% called to generate block outputs
function Outputs(block)

if(block.IsMajorTimeStep)    
    % lineH 1-2-3     : Phaseurs - Grid
    % lineH 4-5-6     : Phaseurs - Machine 1
    % lineH 7-8-9     : Phaseurs - Machine 2
    % lineH 10-11-12  : Topogramme - P,Q 1 et 2 et 3
    % lineH 13-14-15  : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
    lineH = get_param(block.BlockHandle,'UserData');
           
    % Input 3 = Phaseurs ou Topogramme         
    if block.InputPort(3).Data == 0 % connecté au réseau
        lineH(13).SelectedTab = lineH(15); 
    else  % NON connecté au réseau
        lineH(13).SelectedTab = lineH(14);
    end
    
    % PHASEURS RST -------------------------------------------------    
    R = block.InputPort(8).Data;
    % Phase R
    [X, Y] = pol2cart(pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(1),'XData', XData,'YData',YData);

    % Phase S
    [X, Y] = pol2cart(-2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(2),'XData', XData,'YData',YData);

    % Phase T
    [X, Y] = pol2cart(+2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(3),'XData', XData,'YData',YData);
    
    % PHASEURS UVW 1 -------------------------------------------------
    offset = block.InputPort(1).Data;
    R = block.InputPort(2).Data;
    %Phase U1
    [X, Y] = pol2cart(offset+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(4),'XData', XData,'YData',YData);

    %Phase V1
    [X, Y] = pol2cart(offset-2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(5),'XData', XData,'YData',YData);

    %Phase W1
    [X, Y] = pol2cart(offset+2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(6),'XData', XData,'YData',YData);
    
    % PHASEURS UVW 2 -------------------------------------------------
    offset = block.InputPort(9).Data;
    R = block.InputPort(10).Data;
    %Phase U2
    [X, Y] = pol2cart(offset+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(7),'XData', XData,'YData',YData);

    %Phase V2
    [X, Y] = pol2cart(offset-2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(8),'XData', XData,'YData',YData);

    %Phase W2
    [X, Y] = pol2cart(offset+2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(9),'XData', XData,'YData',YData);
    
    
    % TOPOGRAMME -----------------------------------------    
    P1 = block.InputPort(4).Data; %P1
    Q1 = block.InputPort(5).Data; %Q1    
    P2 = block.InputPort(6).Data; %P2
    Q2 = block.InputPort(7).Data; %Q2
    P3 = block.InputPort(11).Data; %P3
    Q3 = block.InputPort(12).Data; %Q3

    set(lineH(10),'XData', Q1, 'YData', P1);                   
    set(lineH(11),'XData', Q2, 'YData', P2);
    set(lineH(12),'XData', Q3, 'YData', P3);
end

%end Outputs

%% Terminate:
% Called at the end of simulation cleanup
function Terminate(block) 
%end Terminate

