function PlotPhaseursEtTopogramme2Machines(block)
% v02 : avec Axis Equal
% Input 1 = Angle phaseurs
% Input 2 = Amplitude des phaseurs Machine 2
% Input 3 = Phaseurs ou Topogramme
% Input 4 = P1
% Input 5 = Q1
% Input 6 = P2
% Input 7 = Q2
% Input 8 = Amplitude des phaseurs Machine 1 (grid)

% Call the setup function
setup(block);

%endfunction
function setup(block)

% exemple trouvé de garder le handle
%s = surf(peaks);
%set_param(block.BlockHandle,'UserData',s);

% Register number of ports
block.NumInputPorts  = 8;
block.NumOutputPorts = 0;

% Setup port properties to be inherited or dynamic
block.SetPreCompInpPortInfoToDynamic;
block.SetPreCompOutPortInfoToDynamic;

% Register parameters
block.NumDialogPrms     = 2;

% Register sample times
%  [0 offset]            : Continuous sample time
%  [positive_num offset] : Discrete sample time
%  [-1, 0]               : Inherited sample time
%  [-2, 0]               : Variable sample time
block.SampleTimes = [0.2 0]; % on rafraichi à 50Hz ...

% Specify the simStateCompliance to default
block.SimStateCompliance = 'DefaultSimState';

% Register all relevant methods
block.RegBlockMethod('Outputs', @Outputs);     % Required
block.RegBlockMethod('Terminate', @Terminate); % Required


% autre exemple de garder le handle
%% Create UI

% lineH 1-2-3   : Phaseurs - Grid
% lineH 4-5-6   : Phaseurs - Machine
% lineH 7-8     : Topogramme - P,Q 1 et 2
% lineH 9-10-11 : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
lineH = get_param(block.BlockHandle,'UserData');

if ishghandle(lineH)
    set(lineH(1),'XData', nan, 'YData',nan);
    set(lineH(2),'XData', nan, 'YData',nan);
    set(lineH(3),'XData', nan, 'YData',nan);
    set(lineH(4),'XData', nan, 'YData',nan);
    set(lineH(5),'XData', nan, 'YData',nan);
    set(lineH(6),'XData', nan, 'YData',nan);
    set(lineH(7),'XData', nan, 'YData',nan);
    set(lineH(8),'XData', nan, 'YData',nan);
else
    myLineWidthPhaseurs = 5; % taille des lignes
    myLineWidthTopogramme1 = 6;
    myLineWidthTopogramme2 = 6;
    mySizeTopogramme = 1.2; % per unit    
    mySizePhaseurs = 1.2;  % per unit
    figH = figure('Name',mfilename,'NumberTitle','off');
    set(figH, 'MenuBar', 'none');
    set(figH, 'ToolBar', 'none');
    tgH = uitabgroup(figH);
    tab1H = uitab(tgH, 'Title','Phaseurs');
    tab2H = uitab(tgH, 'Title','Topogramme');
    
    % PHASEURS -------------------------------------------------
    %ax1 = axes('Parent',figH);
    ax1 = axes(tab1H);
    axis(ax1,'off')
    hold(ax1,'on')
    
    % crée 6 line plot
    phaseursH = plot(ax1, 0, nan, 0, nan, 0, nan, 0, nan, 0, nan, 0, nan, ...
        'Tag','Phaseurs','LineWidth',myLineWidthPhaseurs);        
    axis(ax1,'off')
    axis(ax1,'equal')
    xline(ax1, 0);
    yline(ax1, 0);
    xlim(ax1, [-mySizePhaseurs mySizePhaseurs])
    ylim(ax1, [-mySizePhaseurs mySizePhaseurs])
    title(ax1,'Phaseurs');
    %xlabel('Time')
    %ylabel('Y')
    
    %colors
    set(phaseursH(1),'Color', 'blue');                 % bleu roi
    set(phaseursH(2),'Color', 'red');                  % rouge vif
    set(phaseursH(3),'Color', 'green');                % vert vif
    set(phaseursH(4),'Color', [0.3010 0.7450 0.9330]); % bleu clair
    set(phaseursH(5),'Color', [0.6350 0.0780 0.1840]); % rouge bordeaux
    set(phaseursH(6),'Color', [0.4660 0.6740 0.1880]); % vert pomme    
    
    % cercle Un -> 1pu
    th = 0:pi/50:2*pi;
    xunit = cos(th);
    yunit = sin(th);
    hold(ax1, 'on');
    plot(ax1, xunit, yunit, 'k');
    
    % TOPOGRAMME -------------------------------------------------
    %ax2 = axes('Parent',figH);
    ax2 = axes(tab2H);
    title(ax2,'Topogramme');
    hold(ax2, 'on');
    
    topogrammeH = plot(ax2, 0, nan, 0, nan, 'Tag','Topogramme');
    % machine 1
    set(topogrammeH(1),'LineWidth',myLineWidthTopogramme1,'Marker','o');
    % machine 2
    set(topogrammeH(2),'LineWidth',myLineWidthTopogramme2,'Marker','o');
    axis(ax2,'off');
    axis(ax2,'equal')
    xline(ax2, 0);
    yline(ax2, 0);
    xlim(ax2, [-mySizeTopogramme mySizeTopogramme]);
    ylim(ax2, [-mySizeTopogramme mySizeTopogramme]);
    title(ax2,'Topogramme');
    %xlabel('Time')
    %ylabel('Y')   
    
    % puissance mécanique
    yline(ax2, 0.85);
    yline(ax2, -0.85); %-0.85
    
    % cercle Sn -> 1pu
    th = 0:pi/50:2*pi;
    xunit = cos(th);
    yunit = sin(th);
    hold(ax2, 'on');
    plot(ax2, xunit, yunit, 'k');
    
    % cercle 1/xq 1/xq
%     xd=2.84; 
%     xq=2.44;    
    xd=1.8; 
    xq=0.895;    
    r = (1/xq-1/xd)/2;
    xunit = r*cos(th)+(1/xd+r);
    yunit = r*sin(th);
    hold(ax2, 'on');
    plot(ax2, xunit, yunit, 'k');
    
    %limaçon de pascal pour le courant d'excitation
    th = -pi/4:pi/100:pi/4;
    a=1.23;
    b=(1/xq-1/xd);
    r = a + b*cos(th);
    [X,Y] = pol2cart(th, r);
    plot(ax2, -X+1/xq,Y,'k');    
    
    % limite stabilité statique
    coeff = 1;
    th = -coeff*pi/2:pi/100:coeff*pi/2;

    pstab = (1/xq-1/xd)*sin(th).^2./cos(th);
    [xstab,ystab] = pol2cart(th, pstab);
    
    plot(ax2, -xstab+1/xq,ystab,'k');   
        
    % lineH 1-2-3   : Phaseurs - Grid
    % lineH 4-5-6   : Phaseurs - Machine
    % lineH 7-8     : Topogramme - P,Q 1
    % lineH 9-10-11 : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
    lineH = [phaseursH; topogrammeH; tgH; tab1H; tab2H];
    set_param(block.BlockHandle,'UserData',lineH);
end % END du if existe déjà ------------------------

%end setup

%% CreateUI
% Called to create the

%% Outputs:
% called to generate block outputs
function Outputs(block)

if(block.IsMajorTimeStep)    
    % lineH 1-2-3   : Phaseurs - Grid
    % lineH 4-5-6   : Phaseurs - Machine
    % lineH 7-8     : Topogramme - P,Q 1
    % lineH 9-10-11 : TabGroup Handel + tab1 et tab 2 pour sélectionner le tab
    lineH = get_param(block.BlockHandle,'UserData');
           
    % Input 3 = Phaseurs ou Topogramme         
    if block.InputPort(3).Data == 0 % connecté au réseau
        lineH(9).SelectedTab = lineH(11); 
    else  % NON connecté au réseau
        lineH(9).SelectedTab = lineH(10);
    end
    
    % PHASEURS RST -------------------------------------------------    
    R = block.InputPort(8).Data;
    % Phase R
    [X, Y] = pol2cart(pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(1),'XData', XData,'YData',YData);

    % Phase S
    [X, Y] = pol2cart(-2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(2),'XData', XData,'YData',YData);

    % Phase T
    [X, Y] = pol2cart(+2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(3),'XData', XData,'YData',YData);
    
    % PHASEURS UVW -------------------------------------------------
    offset = block.InputPort(1).Data;
    R = block.InputPort(2).Data;
    %Phase U
    [X, Y] = pol2cart(offset+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(4),'XData', XData,'YData',YData);

    %Phase V
    [X, Y] = pol2cart(offset-2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(5),'XData', XData,'YData',YData);

    %Phase W
    [X, Y] = pol2cart(offset+2*pi/3+pi/2,R); 
    XData = [0, X];
    YData = [0, Y];
    set(lineH(6),'XData', XData,'YData',YData);
    
    % TOPOGRAMME -----------------------------------------    
    P1 = block.InputPort(4).Data; %P1
    Q1 = block.InputPort(5).Data; %Q1    
    P2 = block.InputPort(6).Data; %P2
    Q2 = block.InputPort(7).Data; %Q2

    set(lineH(7),'XData', Q1, 'YData', P1);                   
    set(lineH(8),'XData', Q2, 'YData', P2);
end

%end Outputs

%% Terminate:
% Called at the end of simulation cleanup
function Terminate(block) 
%end Terminate

