% PLECS PETS initialization

% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################

ORANGE_THRESHOLD = 50;

% ===================================
% === Simulation and Coder params ===
% ===================================

%   -----------------------------------------------------------------------
%   NOTE
%   -----------------------------------------------------------------------
% For hardware-related reasons, the ADC needs to get 2 measurements 
% - one at the PWM carrier peak (ADC_m_peak), and 
% - one at the PWM carrier zero (ADC_m_zero)
% and the real measurement is the average of the two samples
% ADC_m = 0.5*(ADC_m_peak + ADC_m_zero)
% This introduces an additional delay to the system
%   -----------------------------------------------------------------------
% To use both measurements, the ADC is not triggered by the PWM, but by a CPU timer
% The control task needs to be executed by the ADC trigger
% (otherwise it cannot access the values of the peak and zero measurements) 
% Different timing relationships can be set-up between the ADC timer (Ts) and the PWM period (Tcarrier)
% Consider using one of the following strategies:
% - Ts = 0.5*Tcarrier (ADC is sampled at every peak and every zero, but the CPU load is higher)
% - Ts = 1.5*Tcarrier (ADC is sampled every 1.5 period, but the CPU load is lower)
%   -----------------------------------------------------------------------


% DSP parameters
MOT.Ts = 1e-4; 		    % ADC Sampling and Control Task Execution Period
MOT.f_carrier_PWM = 5e3; 	% Carrier frequency for PWM modulator (SEE NOTE)

GCC.Ts = 1e-4; 			% ADC Sampling and Control Task Execution Period
GCC.f_carrier_PWM = 5e3; 	% Carrier frequency for PWM modulator (SEE NOTE)

ExtModeBufferSize = 1000;

% RT-BOX parameters
Tstep = 10e-6; %Period of one complete cycle


% ===================================
% ===         ADC SETTINGS        ===
% ===================================

% ADC_res = 12;   % Bits
% ADC_Vref = 3.3; % Volts
% 
% I_scale = 25.636363636363637;
% I_offset = -42.300000000000000;
% 
% Vg_scale = 4.848484848484849e+02;
% Vg_offset = -800;
% 
% Vdc_scale = 2.424242424242424e+02;
% Vdc_offset = 0;
% 
% Temp_scale = 1;
% Temp_offset = 0;
% 
% Pot_scale = 6.060606060606061;
% Pot_offset = -10;
% 
% Err_scale = 1;
% Err_offset = 0;

ADC_res = 12;   % Bits
ADC_Vref = 3.0; % Volts

I_scale = 28.200000000000000;
I_offset = -42.300000000000000;

Vg_scale = 5.333333333333334e+02;
Vg_offset = -800;

Vdc_scale = 2.666666666666667e+02;
Vdc_offset = 0;

Temp_scale = 1;
Temp_offset = 0;

Pot_scale = 6.666666666666667;
Pot_offset = -10;

Err_scale = 1;
Err_offset = 0;



% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################