
% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################
PETS_PLECS_init

% PWM parameters
Ts = MOT.Ts;                % defined in PETS_PLECS_init
Fsw = MOT.f_carrier_PWM;    % defined in PETS_PLECS_init

t_blanking = 2e-6;

% Braking chopper control
Vth_up	= 700;
Vth_down = 650;

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################


% #########################################################################
% ##########                 USER DEFINITIONS                  ############
% #########################################################################

% ===================================
% ===    Converter Parameters     ===
% ===================================
Ldc = 33e-3; 		% H
Rdc = 382e-3;		% Ohm
Lac = 3.5e-3; 		% H
Rac = 1;		    % Ohm
Cac = 6.8e-6;		% F
Cdc = 705e-6; 		% F
Csupply = 56e-6; 	% F
Rbr = 240;			% Ohm
Rch = 44;           % Ohm

Rload = 92;        % Ohm (45 to 280 Ohm)

% Induction Machine Parameters ELD040
p = 2;						%pole pairs
Un = 230;			        %rated voltage
In = 7.7;					%rated current
fn = 50;					%rated electrical frequency
wn = 153;				    %rated angular frequency
Rs = 2.6;					%stator resistance
Ls = 0.325;					%stator inductance
Rr = 1.1;				    %rotor resistance
Lr = 0.316;					%rotor inductance
Lm = 0.305;					%mutual inductance
Jm = 0.014;					%moment of inertia
kF = 0.00364;				%friction coefficient
fsw = 5e3;					%switching freq.
Pn = 2200;					%nominal power

% Torque 
T_n = Pn/wn;
SatUp_w = 1.5*T_n;
SatLow_w = -1.5*T_n;

% V-f profile lookup table
V_f_in = [0 0];
V_f_out = [0 0];

% #########################################################################
% ##########               END - USER DEFINITIONS              ############
% #########################################################################


% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################

% ===================================
% = SOFTWARE ERROS AND PROTECTIONS  =
% ===================================

Vdc_max = 760;	
I_max = 10;		% Ldc max current = 8 A, AFE, max 12Arms = 16A


% ===================================
% ===  DSP MOT I/Os definitions   ===
% ===================================
% Naming conventions: deviceType.converterType.from/to.IO_type

% PWMs
DSP.MOT.PWM_CHANNELS = [1, 2, 3];

DSP.MOT.POWERSTAGE_EN = 49;

% DIGITAL OUTPUTS
DSP.MOT.RTBOX.DIG_OUT = [
13;		% ERR_DSP
59; 	% ERR_RST_DSP
34;		% DSP_BR
63		% DSP_THY
];


DSP.MOT.HW.DIG_OUT = [
10; 	% TOWER_GREEN
11;		% TOWER_RED
%31;		% CONTROL CARD LED 2	NOT USED
6;		% REMOTE DIG_OUT 1
7;		% REMOTE DIG_OUT 2
8;		% REMOTE DIG_OUT 3
9;		% REMOTE FAULT_LED (not controllable with default jumper configuration)
60;		% DAC SEL12
61		% DAC SEL3
];
% 58, 	% RST_PPD

DSP_DIG_OUT = [DSP.MOT.RTBOX.DIG_OUT; DSP.MOT.HW.DIG_OUT];

% DIGITAL INPUTS
% ERR is detected by Trip Zone module (GPIO-12)
DSP.MOT.RTBOX.DIG_IN = [
48;		% DSP_VUV feedback for AFE voltage U-V
22;		% OV_Vadc2
14		% BR_OTP  Breaking resistor over temperature signal from GPIO board
];


DSP.MOT.HW.DIG_IN = [
15; 	% BUTTON1	
26; 	% BUTTON2
27		% BUTTON3
];

DSP_DIG_IN = [ DSP.MOT.RTBOX.DIG_IN; DSP.MOT.HW.DIG_IN];

% COMMUNICATION
DSP.MOT.SPI.CLK = 6250000;
DSP.MOT.SPI.BITS_PER_WORDS = 16;
DSP.MOT.SPI.PINS = [16,17,18];  % [SIMO, SOMI, CLK]
DSP.MOT.SPI.CS_PIN = 19;
DSP.MOT.SPI.WORDS_PER_TRANSMISSION = 1;


% ===================================
% ===         ADC SETTINGS        ===
% ===================================
% scales and offsets are defined in PETS_PLECS_init.m

ADC_channels_MOT = [ 
0 		% Iu
1 		% Iv
2 		% Iw
3 		% Vdc
14		% Vsupply
4 		% Heatsink  Temp
12 	    % Pot1
13 	    % Pot2
7       % ERR_CODE
];     

ADC_scales_MOT = [
I_scale; 		% Iu
I_scale; 		% Iv
I_scale; 		% Iw
Vdc_scale; 	    % Vdc
Vdc_scale;	    % Vsupply
Temp_scale;	    % Temp
Pot_scale; 	    % Pot1
Pot_scale; 	    % Pot2
Err_scale;      % ERR_CODE
];	   

ADC_offsets_MOT = [
I_offset; 		% Iu
I_offset; 		% Iv
I_offset; 		% Iw
Vdc_offset;     % Vdc
Vdc_offset;		% Vsupply
Temp_offset; 	% Temp
Pot_offset;     % Pot1
Pot_offset;     % Pot2
Err_offset;     % ERR_CODE
]; 	

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################