
% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################
PETS_PLECS_init

% PWM parameters
Ts = MOT.Ts;                % defined in PETS_PLECS_init
Fsw = MOT.f_carrier_PWM;    % defined in PETS_PLECS_init

t_blanking = 2e-6;

% Braking chopper control
Vth_up	= 630;
Vth_down = 600;

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################


% #########################################################################
% ##########                 USER DEFINITIONS                  ############
% #########################################################################

% ===================================
% ===    Converter Parameters     ===
% ===================================

Ldc = 0;
Rdc = 0;
Lac = 3.5e-3; 		% H
Rac = 1;		    % Ohm
Cac = 6.8e-6;		% F
Cdc = 705e-6; 		% F
Csupply = 56e-6; 	% F
Rbr = 240;			% Ohm
Rch = 44;           % Ohm

Rload = 92;        % Ohm (45 to 280 Ohm)


%Nominal armature voltage and current
Ua_nom = 400;	    % [V]
Ia_nom = 7.8; 	    % [A]	

%Nominal field voltage
Uf_nom = 340;       % [V]

%Power and speed
P_shaft = 2500;     % [W]
Speed_R = 1500;     % [rpm]

% DC Machine Parameters (ELD040)
Omega_n = 50*pi;    % [rad/s]
Ra = 3.8;           % [Ω]
La = 0.05;          % [H]
Rf = 729;           % [Ω]
Lf = 34.6;          % [H]

T_nom = P_shaft/Omega_n;
If_nom = Uf_nom/Rf;

ke = 0.8375;
km = ke;
Nf = 5;

Laf = 5.8;
J = 0.0012;
kF = 0.00364;

% Converter Parameters
Ia_max = 7;
fsw = Fsw;
Tsw = 1/fsw;

% ===================================
% ===  	CONTROL DEFINITIONS		 ===
% ===================================

% Exercise 2 : Define your controller parameters and gains here

% AC Grid parameters (not used in this exercise).
% Vgrid = 220; % RMS of the grid phase voltage
% Vrect = Vgrid*sqrt(3)*sqrt(2);
% Vrect= 400;

method = 1; % Chose discretization model (applied to all the regulators) ->  1 - Forward Euler ; 2 - Backward Euler ; 3 - Tustin

% Armature current controller
Ts_c = MOT.Ts;



% Speed controller
Ts_w = 1; % TO BE DEFINED BY YOU


%-----------------------

Tmax = 0;

Sat_Up_Tem = Tmax;
Sat_Low_Tem = -Tmax;

% #########################################################################
% ##########               END - USER DEFINITIONS              ############
% #########################################################################


% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################

% ===================================
% = SOFTWARE ERROS AND PROTECTIONS  =
% ===================================

Vdc_max = 760;	
I_max = 7;

If_max = 4.5;

% ===================================
% ===  DSP MOT I/Os definitions   ===
% ===================================
% Naming conventions: deviceType.converterType.from/to.IO_type

% PWMs
DSP.MOT.PWM_CHANNELS = [1, 2, 3];

DSP.MOT.POWERSTAGE_EN = 49;

% DIGITAL OUTPUTS
DSP.MOT.RTBOX.DIG_OUT = [
13;		% ERR_DSP
59; 	% ERR_RST_DSP
34;		% DSP_BR
63		% DSP_THY
];


DSP.MOT.HW.DIG_OUT = [
10; 	% TOWER_GREEN
11;		% TOWER_RED
%31;		% CONTROL CARD LED 2	NOT USED
6;		% REMOTE DIG_OUT 1
7;		% REMOTE DIG_OUT 2
8;		% REMOTE DIG_OUT 3
9;		% REMOTE FAULT_LED (not controllable with default jumper configuration)
60;		% DAC SEL12
61		% DAC SEL3
];
% 58, 	% RST_PPD

DSP_DIG_OUT = [DSP.MOT.RTBOX.DIG_OUT; DSP.MOT.HW.DIG_OUT];

% DIGITAL INPUTS
% ERR is detected by Trip Zone module (GPIO-12)
DSP.MOT.RTBOX.DIG_IN = [
48;		% DSP_VUV feedback for AFE voltage U-V
22;		% OV_Vadc2
14		% BR_OTP  Breaking resistor over temperature signal from GPIO board
];


DSP.MOT.HW.DIG_IN = [
15; 	% BUTTON1	
26; 	% BUTTON2
27		% BUTTON3
];

DSP_DIG_IN = [ DSP.MOT.RTBOX.DIG_IN; DSP.MOT.HW.DIG_IN];

% COMMUNICATION
DSP.MOT.SPI.CLK = 6250000;
DSP.MOT.SPI.BITS_PER_WORDS = 16;
DSP.MOT.SPI.PINS = [16,17,18];  % [SIMO, SOMI, CLK]
DSP.MOT.SPI.CS_PIN = 19;
DSP.MOT.SPI.WORDS_PER_TRANSMISSION = 1;


% ===================================
% ===         ADC SETTINGS        ===
% ===================================
% scales and offsets are defined in PETS_PLECS_init.m

ADC_channels_MOT = [ 
0 		% Iu
1 		% Iv
2 		% Iw
3 		% Vdc
14		% Vsupply
4 		% Heatsink  Temp
12 	    % Pot1
13 	    % Pot2
7       % ERR_CODE
];     

ADC_scales_MOT = [
I_scale; 		% Iu
I_scale; 		% Iv
I_scale; 		% Iw
Vdc_scale; 	    % Vdc
Vdc_scale;	    % Vsupply
Temp_scale;	    % Temp
Pot_scale; 	    % Pot1
Pot_scale; 	    % Pot2
Err_scale;      % ERR_CODE
];	   

ADC_offsets_MOT = [
I_offset; 		% Iu
I_offset; 		% Iv
I_offset; 		% Iw
Vdc_offset;     % Vdc
Vdc_offset;		% Vsupply
Temp_offset; 	% Temp
Pot_offset;     % Pot1
Pot_offset;     % Pot2
Err_offset;     % ERR_CODE
]; 	

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################