%                              MOT PART 
% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################

PETS_PLECS_init

% ===================================
% ===    Supplies parameters      ===
% ===================================
n_series = 10; 
n_parallel = 1;

% SunIrradiation applied to full PV string in equal irradiation model 
% and half of the PV string in unequal irradiation model
SunIrradiation = 1; % kW/m^2

% Applied to second half of the string in unequal irradiation model
SunIrradiation2 = 0.8; % kW/m^2

% ===================================
% ===     Initial conditions      ===
% ===================================

% For sources which contain a capcitor:
VC_init = 300;      % initial voltage of the capacitor 


% ===================================
% ===  CST USED FOR POWER PART    ===
% ===================================

Ldc = 33e-3; 		% H
Rdc = 382e-3;		% Ohm
Lac = 3.5e-3; 		% H
Rac = 1;		    % Ohm
Cac = 6.8e-6;		% F
RCac = 0.001;       % Ohm
Cdc = 705e-6; 		% F
Csupply = 56e-6; 	% F
Rbr = 240;			% Ohm
Rch = 44;           % Ohm

Rload = 92;        % Ohm

% ===================================
% == LARA ERRORS AND PROTECTIONS  ===
% ===================================

Vdc_max = 790;
Vdc_min = 300;
I_max = 42.3;


% ==================================
% == RT-BOX MOT I/Os definitions  ==
% ==================================

% DIGITAL INPUTS
RTBOX.MOT.DSP.PWM_IN.CHANNELS = [
0;		% Gu
1;		% Gx
2;		% Gv
3;		% Gx
4;		% Gw
5		% Gz
];

RTBOX.MOT.DSP.PWM_IN.POLARITY = 1;
RTBOX.MOT.DSP.PWM_IN.T_AVG = 1e-6;

RTBOX.MOT.DSP.PWM_EN = 6; % PWM_EN

RTBOX.MOT.DSP.DIG_IN = [
8;		% ERR_DSP
9; 		% ERR_RST_DSP
7;		% DSP_BR
14		% DSP_THY
];

RTBOX.MOT.HW.DIG_IN = [
10; 	% ERR_GPIO
11; 	% ERR_RST_GPIO
12;		% /ERR_PPD
13		% /ERR_RST_PPD
];


% DIGITAL OUTPUTS
RTBOX.MOT.DSP.DIG_OUT = [
8; 		% /ERR
4;		% DSP_VUV
12		% DSP_OV_Vadc2 (on schematic) -> corresponds to GPIO-22/EQEPS-1 (encoder strobe input)
];

RTBOX.MOT.HW.DIG_OUT = [
5;		% ERR0
6;		% ERR1
7;		% ERR2
9;		% FDB_RST
10;		% FDB_T
11		% ORANGE_LED
];

RTBOX.MOT.DSP.ENC_OUT = [
0;		% A
1;		% B
2		% I
];


% ANALOG INPUTS
RTBOX.MOT.HW.ANA_IN.CHANNELS = [
0;		% DC_SUPP_MAG
1;		% AC_SUPP_MAG
4;		% ANA-OUT1-V
5;		% ANA-OUT2-V
6;		% ANA-OUT3-I
7		% RTBOX_LED_ERR
];
RTBOX.MOT.HW.ANA_IN.SCALE = 1;
RTBOX.MOT.HW.ANA_IN.OFFSET = 0; 

% ANALOG OUTPUTS
RTBOX.MOT.DSP.ANA_OUT = [
10; 		% Iu
11; 		% Iv
12; 		% Iw
13; 		% Vdc
15; 		% Vsupply
14			% Heatsink Temperature
];

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################


%                               GCC PART 
% #########################################################################
% ##########              FOR ADVANCED USERS ONLY              ############
% #########################################################################





% ===================================
% ===     Initial conditions      ===
% ===================================

% For sources which contain a capcitor:
VC_init = 600;      % initial voltage of the capacitor 


% ===================================
% == LARA ERRORS AND PROTECTIONS  ===
% ===================================

Vdc_max = 790;
Vdc_min = 300;
I_max = 42.3;
Vg_max = 400;


% ==================================
% == RT-BOX MOT I/Os definitions  ==
% ==================================

% DIGITAL INPUTS
RTBOX.GCC.DSP.PWM_IN.CHANNELS = [
16;		% Gu
17;		% Gx
18;		% Gv
19;		% Gx
20;		% Gw
21		% Gz
];

RTBOX.GCC.DSP.PWM_IN.POLARITY = 1;
RTBOX.GCC.DSP.PWM_IN.T_AVG = 10e-6;

RTBOX.GCC.DSP.PWM_EN = 22; % PWM_EN

RTBOX.GCC.DSP.DIG_IN = [
24;		% ERR_DSP
25; 	% ERR_RST_DSP
23;		% DSP_BR
30		% DSP_THY
];

RTBOX.GCC.HW.DIG_IN = [
26; 	% ERR_GPIO
27; 	% ERR_RST_GPIO
28;		% /ERR_PPD
29		% /ERR_RST_PPD
];


% DIGITAL OUTPUTS
RTBOX.GCC.DSP.DIG_OUT = [
24;     % /ERR
20;		% DSP_VUV
14		% DSP_OV_Vadc2 (on schematic) -> corresponds to GPIO-22/EQEPS-1 (encoder strobe input)
];

RTBOX.GCC.HW.DIG_OUT = [
21;		% ERR0
22;		% ERR1
23;		% ERR2
25;		% FDB_RST
26;		% FDB_T
27		% ORANGE_LED
];


% ANALOG INPUTS
RTBOX.GCC.HW.ANA_IN.CHANNELS = [
2;		% DC_SUPP_MAG
3;		% AC_SUPP_MAG
8;		% ANA-OUT1-V
9;		% ANA-OUT2-V
10;		% ANA-OUT3-I
11		% RTBOX_LED_ERR
];
RTBOX.GCC.HW.ANA_IN.SCALE = 1;
RTBOX.GCC.HW.ANA_IN.OFFSET = 0; 

% ANALOG OUTPUTS
RTBOX.GCC.DSP.ANA_OUT = [
1; 		% Iu
3; 		% Iv
5; 		% Iw
7; 		% Vdc
9; 		% Vsupply
8;	    % Heatsink Temperature
0; 		% VgA
4; 		% VgB
2; 		% VgC
6       % V_App4
];

% #########################################################################
% ##########          END - FOR ADVANCED USERS ONLY            ############
% #########################################################################

