/*
 * C-Script file for: Power Stage/Protection and Measurement MOT/ENCODE
 * Generated with   : PLECS 4.9.2
 * Generated on     : 17 Feb 2025 15:19:06
 */
typedef float real_t;
#define REAL_MAX FLT_MAX
#define REAL_MIN FLT_MIN
#define REAL_EPSILON FLT_EPSILON

struct CScriptStruct
{
   int numInputTerminals;
   int numOutputTerminals;
   int* numInputSignals;
   int* numOutputSignals;
   int numContStates;
   int numDiscStates;
   int numZCSignals;
   int numSampleTimes;
   int numParameters;
   int isMajorTimeStep;
   float time;
   const float ***inputs;
   float ***outputs;
   float *contStates;
   float *contDerivs;
   float *discStates;
   float *zCSignals;
   const int *paramNumDims;
   const int **paramDims;
   const int *paramNumElements;
   const float **paramRealData;
   const char **paramStringData;
   const char * const *sampleHits;
   const float *sampleTimePeriods;
   const float *sampleTimeOffsets;
   const float * const *inputSampleTimePeriods;
   const float * const *inputSampleTimeOffsets;
   float *nextSampleHit;
   const char** errorStatus;
   const char** warningStatus;
   const char** rangeErrorMsg;
   int* rangeErrorLine;
   void (*writeCustomStateDouble)(void*, float);
   float (*readCustomStateDouble)(void*);
   void (*writeCustomStateInt)(void*, int);
   void (*writeCustomStateData)(void*, const void*, int);
   void (*readCustomStateData)(void*, void*, int);
};
#define NumInputs cScriptStruct->numInputSignals[0]
#define NumOutputs cScriptStruct->numOutputSignals[0]
#define Input(signalIdx) (*cScriptStruct->inputs[0][signalIdx])
#define Output(signalIdx) (*cScriptStruct->outputs[0][signalIdx])
#define NumInputTerminals cScriptStruct->numInputTerminals
#define NumOutputTerminals cScriptStruct->numOutputTerminals
#define NumInputSignals(terminalIdx) cScriptStruct->numInputSignals[ \
      terminalIdx]
#define NumOutputSignals(terminalIdx) cScriptStruct->numOutputSignals[ \
      terminalIdx]
#define InputSignal(terminalIdx, \
                    signalIdx) (*cScriptStruct->inputs[terminalIdx][signalIdx])
#define OutputSignal(terminalIdx, \
                     signalIdx) (*cScriptStruct->outputs[terminalIdx][ \
                                    signalIdx])
#define NumContStates cScriptStruct->numContStates
#define NumDiscStates cScriptStruct->numDiscStates
#define NumZCSignals cScriptStruct->numZCSignals
#define NumParameters cScriptStruct->numParameters
#define NumSampleTimes cScriptStruct->numSampleTimes
#define IsMajorStep cScriptStruct->isMajorTimeStep
#define CurrentTime cScriptStruct->time
#define NextSampleHit (*cScriptStruct->nextSampleHit)
#define SetErrorMessage(string) { *cScriptStruct->errorStatus=(string); }
#define SetWarningMessage(string)
#define ContState(idx) cScriptStruct->contStates[idx]
#define ContDeriv(idx) cScriptStruct->contDerivs[idx]
#define DiscState(idx) cScriptStruct->discStates[idx]
#define ZCSignal(idx) cScriptStruct->zCSignals[idx]
#define IsSampleHit(idx) (*cScriptStruct->sampleHits[idx])
#define SampleTimePeriod(idx) cScriptStruct->sampleTimePeriods[idx]
#define SampleTimeOffset(idx) cScriptStruct->sampleTimeOffsets[idx]
#define InputSampleTimePeriod(terminalIdx, \
                              signalIdx) cScriptStruct->inputSampleTimePeriods \
   [terminalIdx][signalIdx]
#define InputSampleTimeOffset(terminalIdx, \
                              signalIdx) cScriptStruct->inputSampleTimeOffsets \
   [terminalIdx][signalIdx]
#define ParamNumDims(idx) cScriptStruct->paramNumDims[idx]
#define ParamDim(pIdx, dIdx) cScriptStruct->paramDims[pIdx][dIdx]
#define ParamRealData(pIdx, dIdx) cScriptStruct->paramRealData[pIdx][dIdx]
#define ParamStringData(pIdx) cScriptStruct->paramStringData[pIdx]

void Plant_0_cScriptStart(const struct CScriptStruct *cScriptStruct)
{
}

void Plant_0_cScriptOutput(const struct CScriptStruct *cScriptStruct)
{
   if(InputSignal(0,0) == 1)            // Manual Error (from DSP)
   {
      OutputSignal(0,0)=1;
      OutputSignal(0,1)=1;
      OutputSignal(0,2)=1;
   }
   else if(InputSignal(0,1) == 1) // Application Board Error
   {
      OutputSignal(0,0)=1;
      OutputSignal(0,1)=1;
      OutputSignal(0,2)=0;
   }
   else if(InputSignal(0,2) == 1) // Power Supply Error
   {
      OutputSignal(0,0)=1;
      OutputSignal(0,1)=0;
      OutputSignal(0,2)=1;
   }
   else if(InputSignal(0,3) == 1) // Heatsink Overtemperature
   {
      OutputSignal(0,0)=1;
      OutputSignal(0,1)=0;
      OutputSignal(0,2)=0;
   }
   else if(InputSignal(0,4) == 1) // Overcurrent
   {
      OutputSignal(0,0)=0;
      OutputSignal(0,1)=1;
      OutputSignal(0,2)=1;
   }
   else if(InputSignal(0,5) == 1) // DC-link Undervoltage
   {
      OutputSignal(0,0)=0;
      OutputSignal(0,1)=1;
      OutputSignal(0,2)=0;
   }
   else if(InputSignal(0,6) == 1) // DC-link Overvoltage
   {
      OutputSignal(0,0)=0;
      OutputSignal(0,1)=0;
      OutputSignal(0,2)=1;
   }
   else                                                                 // No Errors
   {
      OutputSignal(0,0)=0;
      OutputSignal(0,1)=0;
      OutputSignal(0,2)=0;
   }
}

void Plant_0_cScriptUpdate(const struct CScriptStruct *cScriptStruct)
{
}

void Plant_0_cScriptDerivative(const struct CScriptStruct *cScriptStruct)
{
}

void Plant_0_cScriptTerminate(const struct CScriptStruct *cScriptStruct)
{
}
