/*
 * Implementation file for: Exercise_0_Skeleton/Power Stage
 * Generated with         : PLECS 4.9.2
 *                          PLECS RT Box 1 3.1.2
 * Generated on           : 17 Feb 2025 15:19:06
 */
#include "Plant.h"
#ifndef PLECS_HEADER_Plant_h_
#error The wrong header file "Plant.h" was included. Please check your
#error include path to see whether this file name conflicts with the name
#error of another header file.
#endif /* PLECS_HEADER_Plant_h_ */
#if defined(__GNUC__) && (__GNUC__ > 4)
#   define _ALIGNMENT 16
#   define _RESTRICT __restrict
#   define _ALIGN __attribute__((aligned(_ALIGNMENT)))
#   if defined(__clang__)
#      if __has_builtin(__builtin_assume_aligned)
#         define _ASSUME_ALIGNED(a) __builtin_assume_aligned(a, _ALIGNMENT)
#      else
#         define _ASSUME_ALIGNED(a) a
#      endif
#   else
#      define _ASSUME_ALIGNED(a) __builtin_assume_aligned(a, _ALIGNMENT)
#   endif
#else
#   ifndef _RESTRICT
#      define _RESTRICT
#   endif
#   ifndef _ALIGN
#      define _ALIGN
#   endif
#   ifndef _ASSUME_ALIGNED
#      define _ASSUME_ALIGNED(a) a
#   endif
#endif
#include <stdint.h>
#include <stdbool.h>
#include <math.h>
#include <string.h>
#include "plexim/DigitalIn.h"
#include "plexim/AnalogOut.h"
#include "plexim/AnalogIn.h"
#include "plexim/DigitalOut.h"
#include "plexim/Encoder.h"
#include "plexim/hw_wrapper.h"
#include "plexim/SFP.h"
#include "plexim/HIL_Framework.h"
#include "plexim/DigitalOverride.h"
#include "plexim/DataCapture.h"
#include "plexim/ProgrammableValue.h"
#include "plexim/ToFile.h"
#define PLECSRunTimeError(msg) Plant_errorStatus = msg
struct CScriptStruct
{
   int numInputTerminals;
   int numOutputTerminals;
   int* numInputSignals;
   int* numOutputSignals;
   int numContStates;
   int numDiscStates;
   int numZCSignals;
   int numSampleTimes;
   int numParameters;
   int isMajorTimeStep;
   float time;
   const float ***inputs;
   float ***outputs;
   float *contStates;
   float *contDerivs;
   float *discStates;
   float *zCSignals;
   const int *paramNumDims;
   const int **paramDims;
   const int *paramNumElements;
   const float **paramRealData;
   const char **paramStringData;
   const char * const *sampleHits;
   const float *sampleTimePeriods;
   const float *sampleTimeOffsets;
   const float * const *inputSampleTimePeriods;
   const float * const *inputSampleTimeOffsets;
   float *nextSampleHit;
   const char** errorStatus;
   const char** warningStatus;
   const char** rangeErrorMsg;
   int* rangeErrorLine;
   void (*writeCustomStateDouble)(void*, float);
   float (*readCustomStateDouble)(void*);
   void (*writeCustomStateInt)(void*, int);
   void (*writeCustomStateData)(void*, const void*, int);
   void (*readCustomStateData)(void*, void*, int);
};
static struct CScriptStruct Plant_cScriptStruct[2];
#define Plant_UNCONNECTED 0
static float Plant_D_float[9];
static int Plant_D_int[2];
static size_t Plant_D_size_t[2];
static float * _RESTRICT Plant_PM0_x;
static float Plant_PM0_tmpX[1] _ALIGN;
static float Plant_PM0_prevX[1] _ALIGN;
static float Plant_PM0_u[2] _ALIGN;
static float Plant_PM0_prevU[2] _ALIGN;
static float Plant_PM0_y[3] _ALIGN;
static size_t Plant_PM0_topoIdx;
static char Plant_PM0_withDiracs;
static const size_t PM0_Ad_0_rowPtr[] = {
   0,1
};
static const size_t PM0_Ad_0_colIdx[] = {
   0
};
static const float PM0_Ad_0_data[] _ALIGN = {
   0.0361727061f
};
static const size_t PM0_Bd0_0_rowPtr[] = {
   0,2
};
static const size_t PM0_Bd0_0_colIdx[] = {
   0,1
};
static const float PM0_Bd0_0_data[] _ALIGN = {
   -9.97269423e-05f,0.0997269423f
};
static const size_t PM0_Bd1_0_rowPtr[] = {
   0,2
};
static const size_t PM0_Bd1_0_colIdx[] = {
   0,1
};
static const float PM0_Bd1_0_data[] _ALIGN = {
   -0.000864100352f,0.864100352f
};
static const size_t * const PM0_Ad_rowPtr[] = {
   PM0_Ad_0_rowPtr
};
static const size_t * const PM0_Ad_colIdx[] = {
   PM0_Ad_0_colIdx
};
static const float * const Plant_PM0_Ad_data[] = {
   PM0_Ad_0_data
};
static const size_t * const PM0_Bd0_rowPtr[] = {
   PM0_Bd0_0_rowPtr
};
static const size_t * const PM0_Bd0_colIdx[] = {
   PM0_Bd0_0_colIdx
};
static const float * const Plant_PM0_Bd0_data[] = {
   PM0_Bd0_0_data
};
static const size_t * const PM0_Bd1_rowPtr[] = {
   PM0_Bd1_0_rowPtr
};
static const size_t * const PM0_Bd1_colIdx[] = {
   PM0_Bd1_0_colIdx
};
static const float * const Plant_PM0_Bd1_data[] = {
   PM0_Bd1_0_data
};
static size_t Plant_PM0_conductionMasks[1]={
   0
};
static size_t Plant_PM0_directionMasks[1]={
   0
};
static void Plant_PM0_update(const float * _RESTRICT aAd_data,
                             const float * _RESTRICT aBd0_data,
                             const float * _RESTRICT aBd1_data,
                             float * _RESTRICT x)
{
   const float * _RESTRICT Ad_data = _ASSUME_ALIGNED(aAd_data);
   const float * _RESTRICT Bd0_data = _ASSUME_ALIGNED(aBd0_data);
   const float * _RESTRICT Bd1_data = _ASSUME_ALIGNED(aBd1_data);
   const float * _RESTRICT prevX = Plant_PM0_prevX;
   size_t i;
   for (i = 0; i < 1; ++i)
   {
      x[i] = 0;
      {
         const size_t *rowPtr = PM0_Ad_rowPtr[Plant_PM0_topoIdx];
         const size_t *colIdx = PM0_Ad_colIdx[Plant_PM0_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Ad_data[j]*prevX[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM0_Bd0_rowPtr[Plant_PM0_topoIdx];
         const size_t *colIdx = PM0_Bd0_colIdx[Plant_PM0_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Bd0_data[j]*Plant_PM0_prevU[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM0_Bd1_rowPtr[Plant_PM0_topoIdx];
         const size_t *colIdx = PM0_Bd1_colIdx[Plant_PM0_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Bd1_data[j]*Plant_PM0_u[colIdx[j]];
      }
   }
}
static float * _RESTRICT Plant_PM1_x;
static float Plant_PM1_tmpX[1] _ALIGN;
static float Plant_PM1_prevX[1] _ALIGN;
static float Plant_PM1_u[1] _ALIGN;
static float Plant_PM1_prevU[1] _ALIGN;
static float Plant_PM1_y[2] _ALIGN;
static float Plant_PM1_gateSignalBuffer[2] _ALIGN;
static float Plant_PM1_dcsVoltageSignalBuffer[2] _ALIGN;
static size_t Plant_PM1_topoIdx;
static char Plant_PM1_withDiracs;
static const size_t PM1_Ad_0_rowPtr[] = {
   0,0
};
static const size_t PM1_Ad_0_colIdx[] = {
   0
};
static const float PM1_Ad_0_data[] _ALIGN = {
   0
};
static const size_t PM1_Bd0_0_rowPtr[] = {
   0,0
};
static const size_t PM1_Bd0_0_colIdx[] = {
   0
};
static const float PM1_Bd0_0_data[] _ALIGN = {
   0
};
static const size_t PM1_Bd1_0_rowPtr[] = {
   0,0
};
static const size_t PM1_Bd1_0_colIdx[] = {
   0
};
static const float PM1_Bd1_0_data[] _ALIGN = {
   0
};
static const size_t PM1_C_0_0_rowPtr[] = {
   0,0
};
static const size_t PM1_C_0_0_colIdx[] = {
   0
};
static const float PM1_C_0_0_data[] _ALIGN = {
   0
};
static const size_t PM1_D_0_0_rowPtr[] = {
   0,0
};
static const size_t PM1_D_0_0_colIdx[] = {
   0
};
static const float PM1_D_0_0_data[] _ALIGN = {
   0
};
static const size_t PM1_C_1_0_rowPtr[] = {
   0,0
};
static const size_t PM1_C_1_0_colIdx[] = {
   0
};
static const float PM1_C_1_0_data[] _ALIGN = {
   0
};
static const size_t PM1_D_1_0_rowPtr[] = {
   0,0
};
static const size_t PM1_D_1_0_colIdx[] = {
   0
};
static const float PM1_D_1_0_data[] _ALIGN = {
   0
};
static void PM1_collision_0()
{
   float * _RESTRICT x = Plant_PM1_x;
   x[0] = 0.;
}
static size_t PM1_natPreComm_0_0()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   return 0; /* 0_0 */
}
static size_t PM1_natPostComm_0_0()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   if (v[0] > 0)
   {
      return 1; /* 1_0 */
   }
   if (v[1] > 0)
   {
      return 2; /* 1_1 */
   }
   return 0; /* 0_0 */
}
static size_t PM1_forcedComm_0_0()
{
   return 0;                                  /* 0_0 */
}
static const size_t PM1_Ad_1_rowPtr[] = {
   0,1
};
static const size_t PM1_Ad_1_colIdx[] = {
   0
};
static const float PM1_Ad_1_data[] _ALIGN = {
   0.986100234f
};
static const size_t PM1_Bd0_1_rowPtr[] = {
   0,1
};
static const size_t PM1_Bd0_1_colIdx[] = {
   0
};
static const float PM1_Bd0_1_data[] _ALIGN = {
   -7.50543397e-05f
};
static const size_t PM1_Bd1_1_rowPtr[] = {
   0,1
};
static const size_t PM1_Bd1_1_colIdx[] = {
   0
};
static const float PM1_Bd1_1_data[] _ALIGN = {
   -7.54053427e-05f
};
static const size_t PM1_C_0_1_rowPtr[] = {
   0,1
};
static const size_t PM1_C_0_1_colIdx[] = {
   0
};
static const float PM1_C_0_1_data[] _ALIGN = {
   1.f
};
static const size_t PM1_D_0_1_rowPtr[] = {
   0,0
};
static const size_t PM1_D_0_1_colIdx[] = {
   0
};
static const float PM1_D_0_1_data[] _ALIGN = {
   0
};
static const size_t PM1_C_1_1_rowPtr[] = {
   0,1
};
static const size_t PM1_C_1_1_colIdx[] = {
   0
};
static const float PM1_C_1_1_data[] _ALIGN = {
   1.f
};
static const size_t PM1_D_1_1_rowPtr[] = {
   0,0
};
static const size_t PM1_D_1_1_colIdx[] = {
   0
};
static const float PM1_D_1_1_data[] _ALIGN = {
   0
};
static void PM1_collision_1()
{
}
static size_t PM1_natPreComm_1_0()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   if (x[0] >= 0)
   {
      return 0; /* 0_0 */
   }
   return 1; /* 1_0 */
}
static size_t PM1_natPostComm_1_0()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   if (x[0] > 0)
   {
      return 2; /* 1_1 */
   }
   return 1; /* 1_0 */
}
static size_t PM1_forcedComm_1_0()
{
   return 1;                                  /* 1_0 */
}
static size_t PM1_natPreComm_1_1()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   if (-x[0] >= 0)
   {
      return 0; /* 0_0 */
   }
   return 2; /* 1_1 */
}
static size_t PM1_natPostComm_1_1()
{
   const float * const x = Plant_PM1_x;
   const float * const u = Plant_PM1_u;
   const float * const v = Plant_PM1_dcsVoltageSignalBuffer;
   if (-x[0] > 0)
   {
      return 1; /* 1_0 */
   }
   return 2; /* 1_1 */
}
static size_t PM1_forcedComm_1_1()
{
   return 2;                                  /* 1_1 */
}
static const size_t * const PM1_Ad_rowPtr[] = {
   PM1_Ad_0_rowPtr,PM1_Ad_1_rowPtr,PM1_Ad_1_rowPtr
};
static const size_t * const PM1_Ad_colIdx[] = {
   PM1_Ad_0_colIdx,PM1_Ad_1_colIdx,PM1_Ad_1_colIdx
};
static const float * const Plant_PM1_Ad_data[] = {
   PM1_Ad_0_data,PM1_Ad_1_data,PM1_Ad_1_data
};
static const size_t * const PM1_Bd0_rowPtr[] = {
   PM1_Bd0_0_rowPtr,PM1_Bd0_1_rowPtr,PM1_Bd0_1_rowPtr
};
static const size_t * const PM1_Bd0_colIdx[] = {
   PM1_Bd0_0_colIdx,PM1_Bd0_1_colIdx,PM1_Bd0_1_colIdx
};
static const float * const Plant_PM1_Bd0_data[] = {
   PM1_Bd0_0_data,PM1_Bd0_1_data,PM1_Bd0_1_data
};
static const size_t * const PM1_Bd1_rowPtr[] = {
   PM1_Bd1_0_rowPtr,PM1_Bd1_1_rowPtr,PM1_Bd1_1_rowPtr
};
static const size_t * const PM1_Bd1_colIdx[] = {
   PM1_Bd1_0_colIdx,PM1_Bd1_1_colIdx,PM1_Bd1_1_colIdx
};
static const float * const Plant_PM1_Bd1_data[] = {
   PM1_Bd1_0_data,PM1_Bd1_1_data,PM1_Bd1_1_data
};
static const size_t * const PM1_C_0_rowPtr[] = {
   PM1_C_0_0_rowPtr,PM1_C_0_1_rowPtr,PM1_C_0_1_rowPtr
};
static const size_t * const PM1_C_0_colIdx[] = {
   PM1_C_0_0_colIdx,PM1_C_0_1_colIdx,PM1_C_0_1_colIdx
};
static const float * const Plant_PM1_C_0_data[] = {
   PM1_C_0_0_data,PM1_C_0_1_data,PM1_C_0_1_data
};
static const size_t * const PM1_D_0_rowPtr[] = {
   PM1_D_0_0_rowPtr,PM1_D_0_1_rowPtr,PM1_D_0_1_rowPtr
};
static const size_t * const PM1_D_0_colIdx[] = {
   PM1_D_0_0_colIdx,PM1_D_0_1_colIdx,PM1_D_0_1_colIdx
};
static const float * const Plant_PM1_D_0_data[] = {
   PM1_D_0_0_data,PM1_D_0_1_data,PM1_D_0_1_data
};
static const size_t * const PM1_C_1_rowPtr[] = {
   PM1_C_1_0_rowPtr,PM1_C_1_1_rowPtr,PM1_C_1_1_rowPtr
};
static const size_t * const PM1_C_1_colIdx[] = {
   PM1_C_1_0_colIdx,PM1_C_1_1_colIdx,PM1_C_1_1_colIdx
};
static const float * const Plant_PM1_C_1_data[] = {
   PM1_C_1_0_data,PM1_C_1_1_data,PM1_C_1_1_data
};
static const size_t * const PM1_D_1_rowPtr[] = {
   PM1_D_1_0_rowPtr,PM1_D_1_1_rowPtr,PM1_D_1_1_rowPtr
};
static const size_t * const PM1_D_1_colIdx[] = {
   PM1_D_1_0_colIdx,PM1_D_1_1_colIdx,PM1_D_1_1_colIdx
};
static const float * const Plant_PM1_D_1_data[] = {
   PM1_D_1_0_data,PM1_D_1_1_data,PM1_D_1_1_data
};
static void (*const PM1_collision[3]) () = {
   PM1_collision_0,PM1_collision_1,PM1_collision_1
};
static size_t (*const PM1_natPreComm[3]) () = {
   PM1_natPreComm_0_0,PM1_natPreComm_1_0,PM1_natPreComm_1_1
};
static size_t (*const PM1_natPostComm[3]) () = {
   PM1_natPostComm_0_0,PM1_natPostComm_1_0,PM1_natPostComm_1_1
};
static size_t (*const PM1_forcedComm[3]) () = {
   PM1_forcedComm_0_0,PM1_forcedComm_1_0,PM1_forcedComm_1_1
};
static size_t Plant_PM1_conductionMasks[3]={
   0,1,1
};
static size_t Plant_PM1_directionMasks[3]={
   0,0,1
};
static void Plant_PM1_natComm()
{
   size_t oldTopo = Plant_PM1_topoIdx;
   size_t midTopo = Plant_PM1_topoIdx;
   size_t preConductionToggleMask = 0;
   size_t postConductionToggleMask = 0;
   size_t directionToggleMask = 0;
   Plant_PM1_topoIdx = PM1_natPreComm[Plant_PM1_topoIdx]();
   midTopo = Plant_PM1_topoIdx;
   Plant_PM1_topoIdx = PM1_natPostComm[Plant_PM1_topoIdx]();
   preConductionToggleMask = Plant_PM1_conductionMasks[midTopo] ^
                             Plant_PM1_conductionMasks[oldTopo];
   if (preConductionToggleMask)
   {
      postConductionToggleMask =
         Plant_PM1_conductionMasks[Plant_PM1_topoIdx] ^
         Plant_PM1_conductionMasks[midTopo];
      directionToggleMask = Plant_PM1_directionMasks[Plant_PM1_topoIdx] ^
                            Plant_PM1_directionMasks[oldTopo];
      if (postConductionToggleMask &
          (~preConductionToggleMask | directionToggleMask))
      {
         PM1_collision[Plant_PM1_topoIdx]();
      }
      else
      {
         PM1_collision[midTopo]();
      }
   }
}
static void Plant_PM1_forcedComm()
{
   Plant_PM1_topoIdx = PM1_forcedComm[Plant_PM1_topoIdx]();
}
static void Plant_PM1_dcsPostCommutationUpdate()
{
   float * const _RESTRICT u = Plant_PM1_u;
   const float * const _RESTRICT v = Plant_PM1_dcsVoltageSignalBuffer;
   const size_t cnd = Plant_PM1_conductionMasks[Plant_PM1_topoIdx];
   const size_t dir = Plant_PM1_directionMasks[Plant_PM1_topoIdx];

   u[0] =
      (cnd & 1)
      ? ((dir & 1) ? -v[1] : v[0])
      : (0.5f * (v[0] - v[1]));
}
static void Plant_PM1_output_0()
{
   const float * _RESTRICT C_0_data =
      _ASSUME_ALIGNED(Plant_PM1_C_0_data[Plant_PM1_topoIdx]);
   const float * _RESTRICT D_0_data =
      _ASSUME_ALIGNED(Plant_PM1_D_0_data[Plant_PM1_topoIdx]);
   const size_t meterIdx[]={
      1
   };
   float y[1] _ALIGN;
   size_t i;
   for (i = 0; i < 1; ++i)
   {
      y[i] = 0;
      {
         const size_t *rowPtr = PM1_C_0_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_C_0_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(y+i) += C_0_data[j]*Plant_PM1_x[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM1_D_0_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_D_0_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(y+i) += D_0_data[j]*Plant_PM1_u[colIdx[j]];
      }
   }
   for (i = 0; i < 1; ++i)
   {
      Plant_PM1_y[meterIdx[i]] = y[i];
   }
}
static void Plant_PM1_output_1()
{
   const float * _RESTRICT C_1_data =
      _ASSUME_ALIGNED(Plant_PM1_C_1_data[Plant_PM1_topoIdx]);
   const float * _RESTRICT D_1_data =
      _ASSUME_ALIGNED(Plant_PM1_D_1_data[Plant_PM1_topoIdx]);
   const size_t meterIdx[]={
      0
   };
   float y[1] _ALIGN;
   size_t i;
   for (i = 0; i < 1; ++i)
   {
      y[i] = 0;
      {
         const size_t *rowPtr = PM1_C_1_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_C_1_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(y+i) += C_1_data[j]*Plant_PM1_x[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM1_D_1_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_D_1_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(y+i) += D_1_data[j]*Plant_PM1_u[colIdx[j]];
      }
   }
   for (i = 0; i < 1; ++i)
   {
      Plant_PM1_y[meterIdx[i]] = y[i];
   }
}
static void Plant_PM1_update(const float * _RESTRICT aAd_data,
                             const float * _RESTRICT aBd0_data,
                             const float * _RESTRICT aBd1_data,
                             float * _RESTRICT x)
{
   const float * _RESTRICT Ad_data = _ASSUME_ALIGNED(aAd_data);
   const float * _RESTRICT Bd0_data = _ASSUME_ALIGNED(aBd0_data);
   const float * _RESTRICT Bd1_data = _ASSUME_ALIGNED(aBd1_data);
   const float * _RESTRICT prevX = Plant_PM1_prevX;
   size_t i;
   for (i = 0; i < 1; ++i)
   {
      x[i] = 0;
      {
         const size_t *rowPtr = PM1_Ad_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_Ad_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Ad_data[j]*prevX[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM1_Bd0_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_Bd0_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Bd0_data[j]*Plant_PM1_prevU[colIdx[j]];
      }
      {
         const size_t *rowPtr = PM1_Bd1_rowPtr[Plant_PM1_topoIdx];
         const size_t *colIdx = PM1_Bd1_colIdx[Plant_PM1_topoIdx];
         size_t j;
         for (j = rowPtr[i]; j < rowPtr[i+1]; ++j)
            *(x+i) += Bd1_data[j]*Plant_PM1_u[colIdx[j]];
      }
   }
}
static char Plant_first;
void Plant_0_cScriptStart(const struct CScriptStruct *cScriptStruct);
void Plant_0_cScriptOutput(const struct CScriptStruct *cScriptStruct);
void Plant_0_cScriptUpdate(const struct CScriptStruct *cScriptStruct);
void Plant_0_cScriptDerivative(const struct CScriptStruct *cScriptStruct);
void Plant_0_cScriptTerminate(const struct CScriptStruct *cScriptStruct);
void Plant_1_cScriptStart(const struct CScriptStruct *cScriptStruct);
void Plant_1_cScriptOutput(const struct CScriptStruct *cScriptStruct);
void Plant_1_cScriptUpdate(const struct CScriptStruct *cScriptStruct);
void Plant_1_cScriptDerivative(const struct CScriptStruct *cScriptStruct);
void Plant_1_cScriptTerminate(const struct CScriptStruct *cScriptStruct);
static uint32_t Plant_tickLo;
static int32_t Plant_tickHi;
/* Block outputs */
static bool Plant_B_CompareToConstant2[3]; /* Power Stage/Protection and Measurement MOT/Compare to Constant2 */
static float Plant_B_ENCODE[3];     /* Power Stage/Protection and Measurement MOT/ENCODE */
static bool Plant_B_CompareToConstant1; /* Power Stage/Protection and Measurement MOT/Compare to Constant1 */
static bool Plant_B_CompareToConstant; /* Power Stage/Protection and Measurement MOT/Compare to Constant */
static float Plant_B_ENCODE_1[3];   /* Power Stage/Protection and Measurement GCC/ENCODE */
static bool Plant_B_CompareToConstant_1; /* Power Stage/Protection and Measurement GCC/Compare to Constant */
static bool Plant_B_CompareToConstant1_1; /* Power Stage/Protection and Measurement GCC/Compare to Constant1 */
static float Plant_B_Saturation[10]; /* Power Stage/Protection and Measurement GCC/Sensors/Saturation */
static bool Plant_B_RelationalOperator1; /* Power Stage/Protection and Measurement GCC/Sensors/Relational Operator1 */
static bool Plant_B_RelationalOperator; /* Power Stage/Protection and Measurement GCC/Sensors/Relational Operator */
static bool Plant_B_RelationalOperator2; /* Power Stage/Protection and Measurement GCC/Sensors/Relational Operator2 */
static bool Plant_B_CompareToConstant3; /* Power Stage/Protection and Measurement GCC/Compare to Constant3 */
static float Plant_B_Saturation_1[6]; /* Power Stage/Protection and Measurement MOT/Sensors/Saturation */
static bool Plant_B_RelationalOperator1_1; /* Power Stage/Protection and Measurement MOT/Sensors/Relational Operator1 */
static bool Plant_B_RelationalOperator2_1; /* Power Stage/Protection and Measurement MOT/Sensors/Relational Operator2 */
static bool Plant_B_RelationalOperator_1; /* Power Stage/Protection and Measurement MOT/Sensors/Relational Operator */
static bool Plant_B_CompareToConstant3_1; /* Power Stage/Protection and Measurement MOT/Compare to Constant3 */
static float Plant_B_UHB;           /* Power Stage/Power/HB1/Sub-cycle average/UHB/UHB */
static float Plant_B_UHB_i1;        /* Power Stage/Power/HB1/Sub-cycle average/UHB/UHB */
static float Plant_B_PWMsIn_MOT[6]; /* Power Stage/PWMs In_MOT */
static bool Plant_B_LogicalOperator17; /* Power Stage/Protection and Measurement MOT/Logical Operator17 */
static bool Plant_B_LogicalOperator19; /* Power Stage/Protection and Measurement MOT/Logical Operator19 */
static bool Plant_B_LogicalOperator1; /* Power Stage/Protection and Measurement MOT/SR Flip-flop/Logical Operator1 */
static float Plant_B_APP_ERR;       /* Power Stage/Protection and Measurement MOT/APP_ERR */
static float Plant_B_supplyError;   /* Power Stage/Protection and Measurement MOT/supply error */
static float Plant_B_Temp;          /* Power Stage/Protection and Measurement MOT/Temp */
static bool Plant_B_Memory[3];      /* Power Stage/Protection and Measurement MOT/SR Flip-flop/Memory */
static bool Plant_B_LogicalOperator[3]; /* Power Stage/Protection and Measurement MOT/SR Flip-flop/Logical Operator */
static bool Plant_B_LogicalOperator15; /* Power Stage/Protection and Measurement MOT/Logical Operator15 */
static bool Plant_B_LogicalOperator_1; /* Power Stage/Protection and Measurement MOT/Logical Operator */
static float Plant_B_Product1[6];   /* Power Stage/Protection and Measurement MOT/Product1 */
static float Plant_B_GateSignalPreprocessing[3]; /* Power Stage/Power/HB1/Sub-cycle average/Gate Signal Combination/Hardware Preprocessing/Gate Signal Preprocessing */
static float Plant_B_UHB_i2[2];     /* Power Stage/Power/HB1/Sub-cycle average/UHB/UHB */
static bool Plant_B_LogicalOperator9; /* Power Stage/Protection and Measurement MOT/Logical Operator9 */
static float Plant_B_PWMsInGCC[6];  /* Power Stage/PWMs In GCC */
static bool Plant_B_LogicalOperator19_1; /* Power Stage/Protection and Measurement GCC/Logical Operator19 */
static bool Plant_B_LogicalOperator1_1; /* Power Stage/Protection and Measurement GCC/SR Flip-flop/Logical Operator1 */
static float Plant_B_supplyError_1; /* Power Stage/Protection and Measurement GCC/supply error */
static float Plant_B_Temp_1;        /* Power Stage/Protection and Measurement GCC/Temp */
static bool Plant_B_Memory_1[3];    /* Power Stage/Protection and Measurement GCC/SR Flip-flop/Memory */
static bool Plant_B_LogicalOperator_2[3]; /* Power Stage/Protection and Measurement GCC/SR Flip-flop/Logical Operator */
static bool Plant_B_LogicalOperator15_1; /* Power Stage/Protection and Measurement GCC/Logical Operator15 */
static bool Plant_B_LogicalOperator_3; /* Power Stage/Protection and Measurement GCC/Logical Operator */
static float Plant_B_Product1_1[6]; /* Power Stage/Protection and Measurement GCC/Product1 */

#if defined(EXTERNAL_MODE) && EXTERNAL_MODE
static float Plant_ExtModeBuffer[15];
const float * const Plant_ExtModeSignals[] = {
   &Plant_PM0_y[0],
   &Plant_ExtModeBuffer[0],
   &Plant_PM1_y[1],
   &Plant_ExtModeBuffer[1],
   &Plant_ExtModeBuffer[2],
   &Plant_ExtModeBuffer[3],
   &Plant_ExtModeBuffer[4],
   &Plant_ExtModeBuffer[5],
   &Plant_ExtModeBuffer[6],
   &Plant_ExtModeBuffer[7],
   &Plant_ExtModeBuffer[8],
   &Plant_PM0_y[0],
   &Plant_PM1_y[1],
   &Plant_PM1_y[1],
   &Plant_ExtModeBuffer[9],
   &Plant_ExtModeBuffer[10],
   &Plant_ExtModeBuffer[11],
   &Plant_ExtModeBuffer[12],
   &Plant_ExtModeBuffer[13],
   &Plant_PM0_y[0],
   &Plant_ExtModeBuffer[14],
   &Plant_B_Product1[0],
   &Plant_B_Product1[1],
   &Plant_B_Product1[2],
   &Plant_B_Product1[3],
   &Plant_B_Product1[4],
   &Plant_B_Product1[5],
   &Plant_B_Product1_1[0],
   &Plant_B_Product1_1[1],
   &Plant_B_Product1_1[2],
   &Plant_B_Product1_1[3],
   &Plant_B_Product1_1[4],
   &Plant_B_Product1_1[5]
};
#endif /* defined(EXTERNAL_MODE) */

/* Model states */
static float Plant_X_PowerStage_PM0_x; /* Power Stage */
static bool Plant_X_Memory[3];      /* Power Stage/Protection and Measurement MOT/SR Flip-flop/Memory */
static float Plant_X_PowerStage_i1_PM1_x; /* Power Stage */
static bool Plant_X_PowerStage_i2_PM1_s; /* Power Stage */
static bool Plant_X_Memory_1[3];    /* Power Stage/Protection and Measurement GCC/SR Flip-flop/Memory */
static float Plant_X_Assertion;     /* Power Stage/Power/HB1/Sub-cycle average/Gate Signal Combination/Hardware Preprocessing/Assertion/Assert/Assertion */
static bool Plant_X_Relay;          /* Power Stage/Protection and Measurement GCC/Sensors/Relay */
static bool Plant_X_Relay_1;        /* Power Stage/Protection and Measurement MOT/Sensors/Relay */
static float Plant_X_UHB[2];        /* Power Stage/Power/HB1/Sub-cycle average/UHB/UHB */
const char * Plant_errorStatus;
const float Plant_sampleTime = 5e-06f;
const char * const Plant_checksum =
   "683ae51d3d21d3b5a76c4930d6c5dae1523383ee";
/* Target declarations */
struct PlxDataCaptureRegistry plxDataCaptureRegistry[1];
const int plxUseEthercat = 0;
struct PlxProgrammableValueRegistry plxProgrammableValueRegistry[1];
struct PlxToFileRegistry plxToFileRegistry[1];

void Plant_initialize(float time)
{
   float remainder;
   Plant_errorStatus = NULL;
   Plant_tickHi = floor(time/(4294967296.0*Plant_sampleTime));
   remainder = time - Plant_tickHi*4294967296.0*Plant_sampleTime;
   Plant_tickLo = floor(remainder/Plant_sampleTime + .5);
   remainder -= Plant_tickLo*Plant_sampleTime;
   if (fabsf(remainder) > 1e-6*fabsf(time))
   {
      Plant_errorStatus =
         "Start time must be an integer multiple of the base sample time.";
   }

   /* Target pre-initialization */
   plxSetAnalogInputVoltage(0);
   plxSetupDACs(0);
   plxSetDigitalOutVoltage(0);
   plxInitDigitalOut();
   initPWMCapture();
   plxInitDigitalOverride();
   plxSetupAnalogSampling(1, 0, 5.00000000000000041e-06);
   plxSetMaxNumConsecutiveOverruns(5);
   setupSFPSyncMaster(0, 0, 0, 0);
   setupSFPSyncSlave(0, 0, 0);


   /* Initialization for Subsystem : 'Power Stage' */
   Plant_PM0_topoIdx = 0;
   Plant_X_PowerStage_PM0_x = 600;
   Plant_PM0_x = &Plant_X_PowerStage_PM0_x;

   /* Initialization for PWM Capture : 'Power Stage/PWMs In_MOT' */
   plxSetupPWMCaptureChannel(0, 1, 1);
   plxSetupPWMCaptureChannel(1, 1, 1);
   plxSetupPWMCaptureChannel(2, 1, 1);
   plxSetupPWMCaptureChannel(3, 1, 1);
   plxSetupPWMCaptureChannel(4, 1, 1);
   plxSetupPWMCaptureChannel(5, 1, 1);
   Plant_D_size_t[0] = 0;
   Plant_D_int[0] = 1;

   /* Initialization for Digital In : 'Power Stage/PWM_EN_MOT' */
   plxSetupDigitalInput(6, 1);

   /* Initialization for Digital In : 'Power Stage/Digital In MOT' */
   plxSetupDigitalInput(8, 1);
   plxSetupDigitalInput(9, 1);
   plxSetupDigitalInput(7, 1);
   plxSetupDigitalInput(14, 1);
   plxSetupDigitalInput(10, 1);
   plxSetupDigitalInput(11, 1);
   plxSetupDigitalInput(12, 1);
   plxSetupDigitalInput(13, 1);

   /* Initialization for Memory : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Memory' */
   Plant_X_Memory[0] = false;
   Plant_X_Memory[1] = false;
   Plant_X_Memory[2] = false;

   /* Initialization for Subsystem : 'Power Stage' */
   {
      static int numInputSignals[] = {
         7
      };
      static const float* inputPtrs[] = {
         &Plant_D_float[0], &Plant_B_APP_ERR, &Plant_B_supplyError,
         &Plant_B_Temp, &Plant_D_float[1], &Plant_D_float[2],
         &Plant_D_float[3]
      };
      static const float** inputs[] = {
         &inputPtrs[0]
      };
      static int numOutputSignals[] = {
         3
      };
      static float* outputPtrs[] = {
         &Plant_B_ENCODE[0], &Plant_B_ENCODE[1], &Plant_B_ENCODE[2]
      };
      static float** outputs[] = {
         &outputPtrs[0]
      };
      static float nextSampleHit;
      static const char contTaskHit = '\001';
      static const char * sampleHits[] = {
         &contTaskHit
      };
      static float sampleTimePeriods[] = {
         0
      };
      static float sampleTimeOffsets[] = {
         0
      };
      static float terminalSampleTimePeriods[] = {
         0.f, INFINITY, INFINITY, INFINITY, 0.f, 0.f, 0.f
      };
      static float terminalSampleTimeOffsets[] = {
         -1.f, 0.f, 0.f, 0.f, -1.f, -1.f, -1.f
      };
      static const float* terminalSampleTimePeriodPtrs[] = {
         &terminalSampleTimePeriods[0]
      };
      static const float* terminalSampleTimeOffsetPtrs[] = {
         &terminalSampleTimeOffsets[0]
      };
      static const char* errorStatus;
      static const char* warningStatus;
      static const char* rangeErrorMsg;
      errorStatus = NULL;
      warningStatus = NULL;
      rangeErrorMsg = NULL;
      Plant_cScriptStruct[0].isMajorTimeStep = 1;
      Plant_cScriptStruct[0].numInputTerminals = 1;
      Plant_cScriptStruct[0].numInputSignals = numInputSignals;
      Plant_cScriptStruct[0].inputs = inputs;
      Plant_cScriptStruct[0].numOutputTerminals = 1;
      Plant_cScriptStruct[0].numOutputSignals = numOutputSignals;
      Plant_cScriptStruct[0].outputs = outputs;
      Plant_cScriptStruct[0].numContStates = 0;
      Plant_cScriptStruct[0].contStates = NULL;
      Plant_cScriptStruct[0].contDerivs = NULL;
      Plant_cScriptStruct[0].numDiscStates = 0;
      Plant_cScriptStruct[0].discStates = NULL;
      Plant_cScriptStruct[0].numZCSignals = 0;
      Plant_cScriptStruct[0].numParameters = 0;
      Plant_cScriptStruct[0].paramNumDims = NULL;
      Plant_cScriptStruct[0].paramDims = NULL;
      Plant_cScriptStruct[0].paramNumElements = NULL;
      Plant_cScriptStruct[0].paramRealData = NULL;
      Plant_cScriptStruct[0].paramStringData = NULL;
      Plant_cScriptStruct[0].numSampleTimes = 1;
      Plant_cScriptStruct[0].sampleTimePeriods = sampleTimePeriods;
      Plant_cScriptStruct[0].sampleTimeOffsets = sampleTimeOffsets;
      Plant_cScriptStruct[0].inputSampleTimePeriods =
         terminalSampleTimePeriodPtrs;
      Plant_cScriptStruct[0].inputSampleTimeOffsets =
         terminalSampleTimeOffsetPtrs;
      Plant_cScriptStruct[0].sampleHits = sampleHits;
      Plant_cScriptStruct[0].nextSampleHit = &nextSampleHit;
      Plant_cScriptStruct[0].errorStatus = &errorStatus;
      Plant_cScriptStruct[0].warningStatus = &warningStatus;
      Plant_cScriptStruct[0].rangeErrorMsg = &rangeErrorMsg;
      Plant_0_cScriptStart(&Plant_cScriptStruct[0]);
      if (*Plant_cScriptStruct[0].errorStatus)
         Plant_errorStatus = *Plant_cScriptStruct[0].errorStatus;
   }
   Plant_X_PowerStage_i2_PM1_s = 0;
   Plant_PM1_topoIdx = 0;
   Plant_X_PowerStage_i1_PM1_x = 0;
   Plant_PM1_x = &Plant_X_PowerStage_i1_PM1_x;

   /* Initialization for PWM Capture : 'Power Stage/PWMs In GCC' */
   plxSetupPWMCaptureChannel(16, 1, 1);
   plxSetupPWMCaptureChannel(17, 1, 1);
   plxSetupPWMCaptureChannel(18, 1, 1);
   plxSetupPWMCaptureChannel(19, 1, 1);
   plxSetupPWMCaptureChannel(20, 1, 1);
   plxSetupPWMCaptureChannel(21, 1, 1);
   Plant_D_size_t[1] = 0;
   Plant_D_int[1] = 1;

   /* Initialization for Digital In : 'Power Stage/PWM_EN_GCC' */
   plxSetupDigitalInput(22, 1);

   /* Initialization for Digital In : 'Power Stage/Digital In GCC' */
   plxSetupDigitalInput(24, 1);
   plxSetupDigitalInput(25, 1);
   plxSetupDigitalInput(23, 1);
   plxSetupDigitalInput(30, 1);
   plxSetupDigitalInput(26, 1);
   plxSetupDigitalInput(27, 1);
   plxSetupDigitalInput(28, 1);
   plxSetupDigitalInput(29, 1);

   /* Initialization for C-Script : 'Power Stage/Protection and Measurement GCC/ENCODE' */
   {
      static int numInputSignals[] = {
         7
      };
      static const float* inputPtrs[] = {
         &Plant_D_float[4], &Plant_D_float[5], &Plant_B_supplyError_1,
         &Plant_B_Temp_1, &Plant_D_float[6], &Plant_D_float[7],
         &Plant_D_float[8]
      };
      static const float** inputs[] = {
         &inputPtrs[0]
      };
      static int numOutputSignals[] = {
         3
      };
      static float* outputPtrs[] = {
         &Plant_B_ENCODE_1[0], &Plant_B_ENCODE_1[1], &Plant_B_ENCODE_1[2]
      };
      static float** outputs[] = {
         &outputPtrs[0]
      };
      static float nextSampleHit;
      static const char contTaskHit = '\001';
      static const char * sampleHits[] = {
         &contTaskHit
      };
      static float sampleTimePeriods[] = {
         0
      };
      static float sampleTimeOffsets[] = {
         0
      };
      static float terminalSampleTimePeriods[] = {
         0.f, INFINITY, INFINITY, INFINITY, INFINITY, 0.f, 0.f
      };
      static float terminalSampleTimeOffsets[] = {
         -1.f, 0.f, 0.f, 0.f, 0.f, -1.f, -1.f
      };
      static const float* terminalSampleTimePeriodPtrs[] = {
         &terminalSampleTimePeriods[0]
      };
      static const float* terminalSampleTimeOffsetPtrs[] = {
         &terminalSampleTimeOffsets[0]
      };
      static const char* errorStatus;
      static const char* warningStatus;
      static const char* rangeErrorMsg;
      errorStatus = NULL;
      warningStatus = NULL;
      rangeErrorMsg = NULL;
      Plant_cScriptStruct[1].isMajorTimeStep = 1;
      Plant_cScriptStruct[1].numInputTerminals = 1;
      Plant_cScriptStruct[1].numInputSignals = numInputSignals;
      Plant_cScriptStruct[1].inputs = inputs;
      Plant_cScriptStruct[1].numOutputTerminals = 1;
      Plant_cScriptStruct[1].numOutputSignals = numOutputSignals;
      Plant_cScriptStruct[1].outputs = outputs;
      Plant_cScriptStruct[1].numContStates = 0;
      Plant_cScriptStruct[1].contStates = NULL;
      Plant_cScriptStruct[1].contDerivs = NULL;
      Plant_cScriptStruct[1].numDiscStates = 0;
      Plant_cScriptStruct[1].discStates = NULL;
      Plant_cScriptStruct[1].numZCSignals = 0;
      Plant_cScriptStruct[1].numParameters = 0;
      Plant_cScriptStruct[1].paramNumDims = NULL;
      Plant_cScriptStruct[1].paramDims = NULL;
      Plant_cScriptStruct[1].paramNumElements = NULL;
      Plant_cScriptStruct[1].paramRealData = NULL;
      Plant_cScriptStruct[1].paramStringData = NULL;
      Plant_cScriptStruct[1].numSampleTimes = 1;
      Plant_cScriptStruct[1].sampleTimePeriods = sampleTimePeriods;
      Plant_cScriptStruct[1].sampleTimeOffsets = sampleTimeOffsets;
      Plant_cScriptStruct[1].inputSampleTimePeriods =
         terminalSampleTimePeriodPtrs;
      Plant_cScriptStruct[1].inputSampleTimeOffsets =
         terminalSampleTimeOffsetPtrs;
      Plant_cScriptStruct[1].sampleHits = sampleHits;
      Plant_cScriptStruct[1].nextSampleHit = &nextSampleHit;
      Plant_cScriptStruct[1].errorStatus = &errorStatus;
      Plant_cScriptStruct[1].warningStatus = &warningStatus;
      Plant_cScriptStruct[1].rangeErrorMsg = &rangeErrorMsg;
      Plant_1_cScriptStart(&Plant_cScriptStruct[1]);
      if (*Plant_cScriptStruct[1].errorStatus)
         Plant_errorStatus = *Plant_cScriptStruct[1].errorStatus;
   }

   /* Initialization for Memory : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Memory' */
   Plant_X_Memory_1[0] = false;
   Plant_X_Memory_1[1] = false;
   Plant_X_Memory_1[2] = false;

   /* Initialization for Analog Out : 'Power Stage/Analog Out GCC' */
   setupAnalogOut(1, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(3, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(5, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(7, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(9, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(8, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(0, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(4, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(2, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);
   setupAnalogOut(6, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.000000000e+00);

   /* Initialization for Analog In : 'Power Stage/Analog In_GCC' */
   setupAnalogIn(2, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(3, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(8, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(9, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(10, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(11, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);

   /* Initialization for Relay : 'Power Stage/Protection and Measurement GCC/Sensors/Relay' */
   Plant_X_Relay = 0;

   /* Initialization for Digital Out : 'Power Stage/Digital Out GCC' */
   setupDigitalOut(21, DO_GPIO, DO_NINV);
   setupDigitalOut(22, DO_GPIO, DO_NINV);
   setupDigitalOut(23, DO_GPIO, DO_NINV);
   setupDigitalOut(25, DO_GPIO, DO_NINV);
   setupDigitalOut(26, DO_GPIO, DO_NINV);
   setupDigitalOut(27, DO_GPIO, DO_NINV);
   setupDigitalOut(24, DO_GPIO, DO_NINV);
   setupDigitalOut(20, DO_GPIO, DO_NINV);
   setupDigitalOut(14, DO_GPIO, DO_NINV);

   /* Initialization for Analog Out : 'Power Stage/Analog Out MOT' */
   setupAnalogOut(10, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);
   setupAnalogOut(11, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);
   setupAnalogOut(12, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);
   setupAnalogOut(13, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);
   setupAnalogOut(15, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);
   setupAnalogOut(14, 1.000000000e+00f, 0.000000000e+00f, 0.000000000e+00,
                  3.300000000e+00);

   /* Initialization for Analog In : 'Power Stage/Analog In MOT' */
   setupAnalogIn(0, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(1, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(4, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(5, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(6, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);
   setupAnalogIn(7, 1.000000000e+00f, 0.000000000e+00f, 0, 0,
                 0.000000000e+00f);

   /* Initialization for Relay : 'Power Stage/Protection and Measurement MOT/Sensors/Relay' */
   Plant_X_Relay_1 = 0;

   /* Initialization for Digital Out : 'Power Stage/Digital Out MOT' */
   setupDigitalOut(5, DO_GPIO, DO_NINV);
   setupDigitalOut(6, DO_GPIO, DO_NINV);
   setupDigitalOut(7, DO_GPIO, DO_NINV);
   setupDigitalOut(9, DO_GPIO, DO_NINV);
   setupDigitalOut(10, DO_GPIO, DO_NINV);
   setupDigitalOut(11, DO_GPIO, DO_NINV);
   setupDigitalOut(8, DO_GPIO, DO_NINV);
   setupDigitalOut(4, DO_GPIO, DO_NINV);
   setupDigitalOut(12, DO_GPIO, DO_NINV);

   /* Initialization for Incremental Encoder : 'Power Stage/Encoder MOT' */
   setupDigitalOut(0, DO_ENC1A, DO_NINV);
   setupDigitalOut(1, DO_ENC1B, DO_NINV);
   setupDigitalOut(2, DO_ENC1I, DO_NINV);
   setupEncoder(ENC1, 5e-06, 1024, 1);

   /* Initialization for Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_X_UHB[0] = 0;
   Plant_X_UHB[1] = 0;
   Plant_first = 1;
}

void Plant_step(void)
{
   if (Plant_errorStatus)
   {
      return;
   }

   /* Electrical model */


   /* Electrical model input */
   /* Voltage Source DC : 'Power Stage/Power/V_dc' */
   Plant_PM0_u[1]=315.f;
   /* End of electrical model input */
   if (!Plant_first)
   {
      memcpy(Plant_PM0_prevX,Plant_PM0_x,1*sizeof(float));
      Plant_PM0_update(Plant_PM0_Ad_data[Plant_PM0_topoIdx],
                       Plant_PM0_Bd0_data[Plant_PM0_topoIdx],
                       Plant_PM0_Bd1_data[Plant_PM0_topoIdx],Plant_PM0_x);
   }
   Plant_PM0_y[0] = 1.f*Plant_PM0_x[0];
   Plant_PM0_y[1] = 1.f*Plant_PM0_x[0];
   /* End of electrical model output */

   /* End of electrical model */
   /* PWM Capture : 'Power Stage/PWMs In_MOT' */
   {
      float* result = &Plant_B_PWMsIn_MOT[0];
      *result = plxGetDigitalInAveraged(0);
   }
   {
      float* result = &Plant_B_PWMsIn_MOT[1];
      *result = plxGetDigitalInAveraged(1);
   }
   {
      float* result = &Plant_B_PWMsIn_MOT[2];
      *result = plxGetDigitalInAveraged(2);
   }
   {
      float* result = &Plant_B_PWMsIn_MOT[3];
      *result = plxGetDigitalInAveraged(3);
   }
   {
      float* result = &Plant_B_PWMsIn_MOT[4];
      *result = plxGetDigitalInAveraged(4);
   }
   {
      float* result = &Plant_B_PWMsIn_MOT[5];
      *result = plxGetDigitalInAveraged(5);
   }
   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator17'
    * incorporates
    *  Digital In : 'Power Stage/PWM_EN_MOT'
    */
   Plant_B_LogicalOperator17 = !(getDigitalIn(6));

   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator19'
    * incorporates
    *  Digital In : 'Power Stage/Digital In MOT'
    */
   Plant_B_LogicalOperator19 = !(getDigitalIn(9));

   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Logical\nOperator1' */
   Plant_B_LogicalOperator1 = !Plant_B_LogicalOperator19;

   /* Constant : 'Power Stage/Protection and Measurement MOT/APP_ERR' */
   Plant_B_APP_ERR = 0.f;

   /* Constant : 'Power Stage/Protection and Measurement MOT/supply error' */
   Plant_B_supplyError = 0.f;

   /* Constant : 'Power Stage/Protection and Measurement MOT/Temp' */
   Plant_B_Temp = 0.f;

   /* Compare to Constant : 'Power Stage/Protection and Measurement MOT/Compare to\nConstant1'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant1 = Plant_PM0_y[0] < 300.f;

   /* Compare to Constant : 'Power Stage/Protection and Measurement MOT/Compare to\nConstant'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant = Plant_PM0_y[0] > 790.f;

   /* Memory : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Memory' */
   Plant_B_Memory[0] = Plant_X_Memory[0];
   Plant_B_Memory[1] = Plant_X_Memory[1];
   Plant_B_Memory[2] = Plant_X_Memory[2];

   /* Electrical model */
   if (!Plant_first)
   {
      memcpy(Plant_PM1_prevX,Plant_PM1_x,1*sizeof(float));
      Plant_PM1_update(Plant_PM1_Ad_data[Plant_PM1_topoIdx],
                       Plant_PM1_Bd0_data[Plant_PM1_topoIdx],
                       Plant_PM1_Bd1_data[Plant_PM1_topoIdx],Plant_PM1_x);
   }


   /* Electrical model output */
   Plant_PM1_output_0();
   /* End of electrical model output */
   /* Compare to Constant : 'Power Stage/Protection and Measurement MOT/Compare to\nConstant2'
    * incorporates
    *  Ammeter : 'Power Stage/Power/Am1'
    *  Abs : 'Power Stage/Protection and Measurement MOT/Abs'
    *  Constant : 'Power Stage/Power/Constant4'
    */
   Plant_B_CompareToConstant2[0] = fabsf(Plant_PM1_y[1]) > 42.3f;
   Plant_B_CompareToConstant2[1] = fabsf(0.f) > 42.3f;
   Plant_B_CompareToConstant2[2] = fabsf(0.f) > 42.3f;

   /* C-Script : 'Power Stage/Protection and Measurement MOT/ENCODE' */
   Plant_D_float[0] = !(getDigitalIn(8));
   Plant_D_float[1] = Plant_B_CompareToConstant2[0] ||
                      Plant_B_CompareToConstant2[1] ||
                      Plant_B_CompareToConstant2[2];
   Plant_D_float[2] = Plant_B_CompareToConstant1;
   Plant_D_float[3] = Plant_B_CompareToConstant;
   Plant_0_cScriptOutput(&Plant_cScriptStruct[0]);
   if (*Plant_cScriptStruct[0].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[0].errorStatus;

   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Logical\nOperator2'
    */
   Plant_B_LogicalOperator[0] = Plant_B_LogicalOperator1 &&
                                (Plant_B_ENCODE[0] || Plant_B_Memory[0]);
   Plant_B_LogicalOperator[1] = Plant_B_LogicalOperator1 &&
                                (Plant_B_ENCODE[1] || Plant_B_Memory[1]);
   Plant_B_LogicalOperator[2] = Plant_B_LogicalOperator1 &&
                                (Plant_B_ENCODE[2] || Plant_B_Memory[2]);

   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator15'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator2'
    */
   Plant_B_LogicalOperator15 =
      !(Plant_B_LogicalOperator[0] || Plant_B_LogicalOperator[1] ||
        Plant_B_LogicalOperator[2]);

   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator23'
    */
   Plant_B_LogicalOperator_1 = Plant_B_LogicalOperator17 &&
                               Plant_B_LogicalOperator15 &&
                               (!Plant_B_LogicalOperator19);

   /* Product : 'Power Stage/Protection and Measurement MOT/Product1'
    * incorporates
    *  Sum : 'Power Stage/Protection and Measurement MOT/Sum1'
    *  Constant : 'Power Stage/Protection and Measurement MOT/Constant'
    *  Data Type : 'Power Stage/Protection and Measurement MOT/Data Type'
    */
   Plant_B_Product1[0] =
      (1.f - Plant_B_PWMsIn_MOT[0]) * ((float)Plant_B_LogicalOperator_1);
   Plant_B_Product1[1] =
      (1.f - Plant_B_PWMsIn_MOT[1]) * ((float)Plant_B_LogicalOperator_1);
   Plant_B_Product1[2] =
      (1.f - Plant_B_PWMsIn_MOT[2]) * ((float)Plant_B_LogicalOperator_1);
   Plant_B_Product1[3] =
      (1.f - Plant_B_PWMsIn_MOT[3]) * ((float)Plant_B_LogicalOperator_1);
   Plant_B_Product1[4] =
      (1.f - Plant_B_PWMsIn_MOT[4]) * ((float)Plant_B_LogicalOperator_1);
   Plant_B_Product1[5] =
      (1.f - Plant_B_PWMsIn_MOT[5]) * ((float)Plant_B_LogicalOperator_1);

   /* Target Code Block : 'Power Stage/Power/HB1/Sub-cycle average/Gate Signal\nCombination/Hardware Preprocessing/Gate Signal\nPreprocessing' */
   Plant_B_GateSignalPreprocessing[0] = Plant_B_Product1[0];
   Plant_B_GateSignalPreprocessing[1] = Plant_B_Product1[1];
   Plant_B_GateSignalPreprocessing[2] =
      ((Plant_B_Product1[0]) + (Plant_B_Product1[1]) < 1.000001);

   /* Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_B_UHB_i2[0] =
      (((Plant_B_GateSignalPreprocessing[1]) - (1.f))*(Plant_PM0_y[1]));
   Plant_B_UHB_i2[1] =
      (((Plant_B_GateSignalPreprocessing[0]) - (0.f))*(Plant_PM0_y[1]));

   /* Commutation */
   Plant_PM1_dcsVoltageSignalBuffer[1] = Plant_B_UHB_i2[1];
   Plant_PM1_dcsVoltageSignalBuffer[0] = Plant_B_UHB_i2[0];
   Plant_PM1_natComm();
   Plant_PM1_gateSignalBuffer[1] = Plant_UNCONNECTED;
   Plant_PM1_gateSignalBuffer[0] = Plant_UNCONNECTED;
   Plant_PM1_forcedComm();
   Plant_PM1_dcsPostCommutationUpdate();

   /* Electrical model output */
   Plant_PM1_output_1();
   /* End of electrical model output */

   /* End of electrical model */
   /* Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator9'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator20'
    *  Digital In : 'Power Stage/Digital In MOT'
    *  Logical Operator : 'Power Stage/Protection and Measurement MOT/Logical\nOperator25'
    */
   Plant_B_LogicalOperator9 = (!(getDigitalIn(7))) &&
                              Plant_B_LogicalOperator17 &&
                              Plant_B_LogicalOperator15 &&
                              (!Plant_B_LogicalOperator19);

   /* PWM Capture : 'Power Stage/PWMs In GCC' */
   {
      float* result = &Plant_B_PWMsInGCC[0];
      *result = plxGetDigitalInAveraged(16);
   }
   {
      float* result = &Plant_B_PWMsInGCC[1];
      *result = plxGetDigitalInAveraged(17);
   }
   {
      float* result = &Plant_B_PWMsInGCC[2];
      *result = plxGetDigitalInAveraged(18);
   }
   {
      float* result = &Plant_B_PWMsInGCC[3];
      *result = plxGetDigitalInAveraged(19);
   }
   {
      float* result = &Plant_B_PWMsInGCC[4];
      *result = plxGetDigitalInAveraged(20);
   }
   {
      float* result = &Plant_B_PWMsInGCC[5];
      *result = plxGetDigitalInAveraged(21);
   }
   /* Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator19'
    * incorporates
    *  Digital In : 'Power Stage/Digital In GCC'
    */
   Plant_B_LogicalOperator19_1 = !(getDigitalIn(25));

   /* Logical Operator : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Logical\nOperator1' */
   Plant_B_LogicalOperator1_1 = !Plant_B_LogicalOperator19_1;

   /* Constant : 'Power Stage/Protection and Measurement GCC/supply error' */
   Plant_B_supplyError_1 = 0.f;

   /* Constant : 'Power Stage/Protection and Measurement GCC/Temp' */
   Plant_B_Temp_1 = 0.f;

   /* Compare to Constant : 'Power Stage/Protection and Measurement GCC/Compare to\nConstant1'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant1_1 = Plant_PM0_y[0] < 300.f;

   /* Compare to Constant : 'Power Stage/Protection and Measurement GCC/Compare to\nConstant'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant_1 = Plant_PM0_y[0] > 790.f;

   /* C-Script : 'Power Stage/Protection and Measurement GCC/ENCODE' */
   Plant_D_float[4] = !(getDigitalIn(24));
   Plant_D_float[5] = false;
   Plant_D_float[6] = false;
   Plant_D_float[7] = Plant_B_CompareToConstant1_1;
   Plant_D_float[8] = Plant_B_CompareToConstant_1;
   Plant_1_cScriptOutput(&Plant_cScriptStruct[1]);
   if (*Plant_cScriptStruct[1].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[1].errorStatus;

   /* Memory : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Memory' */
   Plant_B_Memory_1[0] = Plant_X_Memory_1[0];
   Plant_B_Memory_1[1] = Plant_X_Memory_1[1];
   Plant_B_Memory_1[2] = Plant_X_Memory_1[2];

   /* Logical Operator : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Logical\nOperator2'
    */
   Plant_B_LogicalOperator_2[0] = Plant_B_LogicalOperator1_1 &&
                                  (Plant_B_ENCODE_1[0] ||
                                   Plant_B_Memory_1[0]);
   Plant_B_LogicalOperator_2[1] = Plant_B_LogicalOperator1_1 &&
                                  (Plant_B_ENCODE_1[1] ||
                                   Plant_B_Memory_1[1]);
   Plant_B_LogicalOperator_2[2] = Plant_B_LogicalOperator1_1 &&
                                  (Plant_B_ENCODE_1[2] ||
                                   Plant_B_Memory_1[2]);

   /* Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator15'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator2'
    */
   Plant_B_LogicalOperator15_1 =
      !(Plant_B_LogicalOperator_2[2] || Plant_B_LogicalOperator_2[1] ||
        Plant_B_LogicalOperator_2[0]);

   /* Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator17'
    *  Digital In : 'Power Stage/PWM_EN_GCC'
    *  Logical Operator : 'Power Stage/Protection and Measurement GCC/Logical\nOperator23'
    */
   Plant_B_LogicalOperator_3 = (!(getDigitalIn(22))) &&
                               Plant_B_LogicalOperator15_1 &&
                               (!Plant_B_LogicalOperator19_1);

   /* Product : 'Power Stage/Protection and Measurement GCC/Product1'
    * incorporates
    *  Sum : 'Power Stage/Protection and Measurement GCC/Sum1'
    *  Constant : 'Power Stage/Protection and Measurement GCC/Constant'
    *  Data Type : 'Power Stage/Protection and Measurement GCC/Data Type'
    */
   Plant_B_Product1_1[0] =
      (1.f - Plant_B_PWMsInGCC[0]) * ((float)Plant_B_LogicalOperator_3);
   Plant_B_Product1_1[1] =
      (1.f - Plant_B_PWMsInGCC[1]) * ((float)Plant_B_LogicalOperator_3);
   Plant_B_Product1_1[2] =
      (1.f - Plant_B_PWMsInGCC[2]) * ((float)Plant_B_LogicalOperator_3);
   Plant_B_Product1_1[3] =
      (1.f - Plant_B_PWMsInGCC[3]) * ((float)Plant_B_LogicalOperator_3);
   Plant_B_Product1_1[4] =
      (1.f - Plant_B_PWMsInGCC[4]) * ((float)Plant_B_LogicalOperator_3);
   Plant_B_Product1_1[5] =
      (1.f - Plant_B_PWMsInGCC[5]) * ((float)Plant_B_LogicalOperator_3);
   if (!(Plant_B_GateSignalPreprocessing[2]))
   {
      Plant_errorStatus =
         "Assertion failed in 'Power Stage/Power/HB1': Half-bridge shoot-through.";
   }

   /* Saturation : 'Power Stage/Protection and Measurement GCC/Sensors/Saturation'
    * incorporates
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide1'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide2'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide3'
    *  Offset : 'Power Stage/Protection and Measurement GCC/Sensors/Offset3'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    *  Constant : 'Power Stage/Protection and Measurement GCC/Sensors/scale3'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide4'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide5'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide6'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide7'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide8'
    *  Product : 'Power Stage/Protection and Measurement GCC/Sensors/Divide9'
    */
   Plant_B_Saturation[0] = 1.49999988f;
   if (Plant_B_Saturation[0] > 3.f)
   {
      Plant_B_Saturation[0] = 3.f;
   }
   else if (Plant_B_Saturation[0] < 0.f)
   {
      Plant_B_Saturation[0] = 0.f;
   }
   Plant_B_Saturation[1] = 1.49999988f;
   if (Plant_B_Saturation[1] > 3.f)
   {
      Plant_B_Saturation[1] = 3.f;
   }
   else if (Plant_B_Saturation[1] < 0.f)
   {
      Plant_B_Saturation[1] = 0.f;
   }
   Plant_B_Saturation[2] = 1.49999988f;
   if (Plant_B_Saturation[2] > 3.f)
   {
      Plant_B_Saturation[2] = 3.f;
   }
   else if (Plant_B_Saturation[2] < 0.f)
   {
      Plant_B_Saturation[2] = 0.f;
   }
   Plant_B_Saturation[3] = (Plant_PM0_y[0]+0.f) / 266.666667f;
   if (Plant_B_Saturation[3] > 3.f)
   {
      Plant_B_Saturation[3] = 3.f;
   }
   else if (Plant_B_Saturation[3] < 0.f)
   {
      Plant_B_Saturation[3] = 0.f;
   }
   Plant_B_Saturation[4] = 0.00375000015f;
   if (Plant_B_Saturation[4] > 3.f)
   {
      Plant_B_Saturation[4] = 3.f;
   }
   else if (Plant_B_Saturation[4] < 0.f)
   {
      Plant_B_Saturation[4] = 0.f;
   }
   Plant_B_Saturation[5] = 1.f;
   if (Plant_B_Saturation[5] > 3.f)
   {
      Plant_B_Saturation[5] = 3.f;
   }
   else if (Plant_B_Saturation[5] < 0.f)
   {
      Plant_B_Saturation[5] = 0.f;
   }
   Plant_B_Saturation[6] = 1.5f;
   if (Plant_B_Saturation[6] > 3.f)
   {
      Plant_B_Saturation[6] = 3.f;
   }
   else if (Plant_B_Saturation[6] < 0.f)
   {
      Plant_B_Saturation[6] = 0.f;
   }
   Plant_B_Saturation[7] = 1.5f;
   if (Plant_B_Saturation[7] > 3.f)
   {
      Plant_B_Saturation[7] = 3.f;
   }
   else if (Plant_B_Saturation[7] < 0.f)
   {
      Plant_B_Saturation[7] = 0.f;
   }
   Plant_B_Saturation[8] = 1.5f;
   if (Plant_B_Saturation[8] > 3.f)
   {
      Plant_B_Saturation[8] = 3.f;
   }
   else if (Plant_B_Saturation[8] < 0.f)
   {
      Plant_B_Saturation[8] = 0.f;
   }
   Plant_B_Saturation[9] = 1.5f;
   if (Plant_B_Saturation[9] > 3.f)
   {
      Plant_B_Saturation[9] = 3.f;
   }
   else if (Plant_B_Saturation[9] < 0.f)
   {
      Plant_B_Saturation[9] = 0.f;
   }
   /* Analog Out : 'Power Stage/Analog Out GCC' */
   setAnalogOut(1, Plant_B_Saturation[0]);
   setAnalogOut(3, Plant_B_Saturation[1]);
   setAnalogOut(5, Plant_B_Saturation[2]);
   setAnalogOut(7, Plant_B_Saturation[3]);
   setAnalogOut(9, Plant_B_Saturation[4]);
   setAnalogOut(8, Plant_B_Saturation[5]);
   setAnalogOut(0, Plant_B_Saturation[6]);
   setAnalogOut(4, Plant_B_Saturation[7]);
   setAnalogOut(2, Plant_B_Saturation[8]);
   setAnalogOut(6, Plant_B_Saturation[9]);
   /* Relational Operator : 'Power Stage/Protection and Measurement GCC/Sensors/Relational\nOperator'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator = 0.f > Plant_PM0_y[0];

   /* Relational Operator : 'Power Stage/Protection and Measurement GCC/Sensors/Relational\nOperator1'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator1 = 0.f > Plant_PM0_y[0];

   /* Relational Operator : 'Power Stage/Protection and Measurement GCC/Sensors/Relational\nOperator2'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator2 = 0.f > Plant_PM0_y[0];

   /* Compare to Constant : 'Power Stage/Protection and Measurement GCC/Compare to\nConstant3'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant3 = Plant_PM0_y[0] > 50.f;
   /* Digital Out : 'Power Stage/Digital Out GCC' */
   writeDigitalOut(21, ((float)Plant_B_LogicalOperator_2[0]));
   writeDigitalOut(22, ((float)Plant_B_LogicalOperator_2[1]));
   writeDigitalOut(23, ((float)Plant_B_LogicalOperator_2[2]));
   writeDigitalOut(25,
                   ((float)(!(Plant_B_RelationalOperator ||
                              Plant_B_RelationalOperator1 ||
                              Plant_B_RelationalOperator2))));
   writeDigitalOut(26, ((float)Plant_B_RelationalOperator2));
   writeDigitalOut(27, ((float)Plant_B_CompareToConstant3));
   writeDigitalOut(24, ((float)Plant_B_LogicalOperator15_1));
   writeDigitalOut(20, 0.f);
   writeDigitalOut(14, 0.f);
   /* Saturation : 'Power Stage/Protection and Measurement MOT/Sensors/Saturation'
    * incorporates
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide'
    *  Offset : 'Power Stage/Protection and Measurement MOT/Sensors/Offset'
    *  Ammeter : 'Power Stage/Power/Am1'
    *  Constant : 'Power Stage/Protection and Measurement MOT/Sensors/scale'
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide1'
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide2'
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide3'
    *  Offset : 'Power Stage/Protection and Measurement MOT/Sensors/Offset3'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    *  Constant : 'Power Stage/Protection and Measurement MOT/Sensors/scale3'
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide4'
    *  Product : 'Power Stage/Protection and Measurement MOT/Sensors/Divide5'
    */
   Plant_B_Saturation_1[0] = (Plant_PM1_y[1]+42.3f) / 28.2f;
   if (Plant_B_Saturation_1[0] > 3.f)
   {
      Plant_B_Saturation_1[0] = 3.f;
   }
   else if (Plant_B_Saturation_1[0] < 0.f)
   {
      Plant_B_Saturation_1[0] = 0.f;
   }
   Plant_B_Saturation_1[1] = 1.49999988f;
   if (Plant_B_Saturation_1[1] > 3.f)
   {
      Plant_B_Saturation_1[1] = 3.f;
   }
   else if (Plant_B_Saturation_1[1] < 0.f)
   {
      Plant_B_Saturation_1[1] = 0.f;
   }
   Plant_B_Saturation_1[2] = 1.49999988f;
   if (Plant_B_Saturation_1[2] > 3.f)
   {
      Plant_B_Saturation_1[2] = 3.f;
   }
   else if (Plant_B_Saturation_1[2] < 0.f)
   {
      Plant_B_Saturation_1[2] = 0.f;
   }
   Plant_B_Saturation_1[3] = (Plant_PM0_y[0]+0.f) / 266.666667f;
   if (Plant_B_Saturation_1[3] > 3.f)
   {
      Plant_B_Saturation_1[3] = 3.f;
   }
   else if (Plant_B_Saturation_1[3] < 0.f)
   {
      Plant_B_Saturation_1[3] = 0.f;
   }
   Plant_B_Saturation_1[4] = 0.00375000015f;
   if (Plant_B_Saturation_1[4] > 3.f)
   {
      Plant_B_Saturation_1[4] = 3.f;
   }
   else if (Plant_B_Saturation_1[4] < 0.f)
   {
      Plant_B_Saturation_1[4] = 0.f;
   }
   Plant_B_Saturation_1[5] = 1.f;
   if (Plant_B_Saturation_1[5] > 3.f)
   {
      Plant_B_Saturation_1[5] = 3.f;
   }
   else if (Plant_B_Saturation_1[5] < 0.f)
   {
      Plant_B_Saturation_1[5] = 0.f;
   }
   /* Analog Out : 'Power Stage/Analog Out MOT' */
   setAnalogOut(10, Plant_B_Saturation_1[0]);
   setAnalogOut(11, Plant_B_Saturation_1[1]);
   setAnalogOut(12, Plant_B_Saturation_1[2]);
   setAnalogOut(13, Plant_B_Saturation_1[3]);
   setAnalogOut(15, Plant_B_Saturation_1[4]);
   setAnalogOut(14, Plant_B_Saturation_1[5]);
   /* Relational Operator : 'Power Stage/Protection and Measurement MOT/Sensors/Relational\nOperator'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator_1 = 0.f > Plant_PM0_y[0];

   /* Relational Operator : 'Power Stage/Protection and Measurement MOT/Sensors/Relational\nOperator1'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator1_1 = 0.f > Plant_PM0_y[0];

   /* Relational Operator : 'Power Stage/Protection and Measurement MOT/Sensors/Relational\nOperator2'
    * incorporates
    *  Constant : 'Power Stage/Power/Constant'
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_RelationalOperator2_1 = 0.f > Plant_PM0_y[0];

   /* Compare to Constant : 'Power Stage/Protection and Measurement MOT/Compare to\nConstant3'
    * incorporates
    *  Voltmeter : 'Power Stage/Power/Vm2'
    */
   Plant_B_CompareToConstant3_1 = Plant_PM0_y[0] > 50.f;
   /* Digital Out : 'Power Stage/Digital Out MOT' */
   writeDigitalOut(5, ((float)Plant_B_LogicalOperator[0]));
   writeDigitalOut(6, ((float)Plant_B_LogicalOperator[1]));
   writeDigitalOut(7, ((float)Plant_B_LogicalOperator[2]));
   writeDigitalOut(9,
                   ((float)(!(Plant_B_RelationalOperator_1 ||
                              Plant_B_RelationalOperator1_1 ||
                              Plant_B_RelationalOperator2_1))));
   writeDigitalOut(10, ((float)Plant_B_RelationalOperator2_1));
   writeDigitalOut(11, ((float)Plant_B_CompareToConstant3_1));
   writeDigitalOut(8, ((float)Plant_B_LogicalOperator15));
   writeDigitalOut(4, 0.f);
   writeDigitalOut(12, 0.f);

   /* Incremental Encoder : 'Power Stage/Encoder MOT' */
   updateEncoder(ENC1, 0.f);
   /* Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_B_UHB = -Plant_PM1_y[0];
   if (Plant_B_UHB < 0.f)
   {
      Plant_B_UHB = 0.f;
   }

   /* Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_B_UHB_i1 = Plant_PM1_y[0];
   if (Plant_B_UHB_i1 < 0.f)
   {
      Plant_B_UHB_i1 = 0.f;
   }
   Plant_first = 0;
#if defined(EXTERNAL_MODE) && EXTERNAL_MODE
   Plant_ExtModeBuffer[0] = (float)Plant_B_LogicalOperator9;
   Plant_ExtModeBuffer[1] = 0.f;
   Plant_ExtModeBuffer[2] = 0.f;
   Plant_ExtModeBuffer[3] = 0.f;
   Plant_ExtModeBuffer[4] = 0.f;
   Plant_ExtModeBuffer[5] = 0.f;
   Plant_ExtModeBuffer[6] = 0.f;
   Plant_ExtModeBuffer[7] = 0.f;
   Plant_ExtModeBuffer[8] = 0.f;
   Plant_ExtModeBuffer[9] = 0.f;
   Plant_ExtModeBuffer[10] = 0.f;
   Plant_ExtModeBuffer[11] = 0.f;
   Plant_ExtModeBuffer[12] = 0.f;
   Plant_ExtModeBuffer[13] = 0.f;
   Plant_ExtModeBuffer[14] = 1.f;
#endif /* defined(EXTERNAL_MODE) */

   if (Plant_errorStatus)
   {
      return;
   }

   /* Update for Subsystem : 'Power Stage' */


   /* Electrical model input */
   /* Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_PM0_u[0]=
      ((Plant_B_UHB)*
       ((0.5f *
         ((Plant_B_GateSignalPreprocessing[1]) +
       (Plant_X_UHB[0]))) -
     (1.f)) + (Plant_B_UHB_i1)*
       ((0.5f *
         ((Plant_B_GateSignalPreprocessing[0]) + (Plant_X_UHB[1]))) - (0.f)));
   /* Voltage Source DC : 'Power Stage/Power/V_dc' */
   Plant_PM0_u[1]=315.f;
   /* End of electrical model input */
   memcpy(Plant_PM0_prevU,Plant_PM0_u,2*sizeof(float));

   /* Update for Memory : 'Power Stage/Protection and Measurement MOT/SR Flip-flop/Memory' */
   Plant_X_Memory[0] = Plant_B_LogicalOperator[0];
   Plant_X_Memory[1] = Plant_B_LogicalOperator[1];
   Plant_X_Memory[2] = Plant_B_LogicalOperator[2];

   /* Update for Subsystem : 'Power Stage' */


   /* Update for C-Script : 'Power Stage/Protection and Measurement MOT/ENCODE' */
   Plant_0_cScriptUpdate(&Plant_cScriptStruct[0]);
   if (*Plant_cScriptStruct[0].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[0].errorStatus;
   memcpy(Plant_PM1_prevU,Plant_PM1_u,1*sizeof(float));

   /* Update for C-Script : 'Power Stage/Protection and Measurement GCC/ENCODE' */
   Plant_1_cScriptUpdate(&Plant_cScriptStruct[1]);
   if (*Plant_cScriptStruct[1].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[1].errorStatus;

   /* Update for Memory : 'Power Stage/Protection and Measurement GCC/SR Flip-flop/Memory' */
   Plant_X_Memory_1[0] = Plant_B_LogicalOperator_2[0];
   Plant_X_Memory_1[1] = Plant_B_LogicalOperator_2[1];
   Plant_X_Memory_1[2] = Plant_B_LogicalOperator_2[2];

   /* Update for Universal Half Bridge : 'Power Stage/Power/HB1/Sub-cycle average/UHB/UHB' */
   Plant_X_UHB[0] = Plant_B_GateSignalPreprocessing[1];
   Plant_X_UHB[1] = Plant_B_GateSignalPreprocessing[0];
}

void Plant_terminate(void)
{
   /* Termination for Subsystem : 'Power Stage' */
   Plant_0_cScriptTerminate(&Plant_cScriptStruct[0]);
   if (*Plant_cScriptStruct[0].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[0].errorStatus;
   /* Termination for C-Script : 'Power Stage/Protection and Measurement GCC/ENCODE' */
   Plant_1_cScriptTerminate(&Plant_cScriptStruct[1]);
   if (*Plant_cScriptStruct[1].errorStatus)
      Plant_errorStatus = *Plant_cScriptStruct[1].errorStatus;
}
