/*
 * Header file for: Exercise_0_Skeleton/DSP 2: MOT
 * Generated with : PLECS 4.9.2
 *                  TI2833x 1.9.2
 * Generated on   : 17 Feb 2025 15:19:25
 */
#ifndef PLECS_HEADER_DSP_2_MOT_h_
#define PLECS_HEADER_DSP_2_MOT_h_

#include <stdbool.h>
#include <stdint.h>

/* Target typedefs */
typedef int_fast8_t int8_t;
typedef uint_fast8_t uint8_t;


/* Model floating point type */
typedef float DSP_2_MOT_FloatType;

/* Target declarations */
extern void DSP_2_MOT_background(void);

/* Model checksum */
extern const char * const DSP_2_MOT_checksum;

/* Model error status */
extern const char * DSP_2_MOT_errorStatus;


/* Model sample time */
extern const float DSP_2_MOT_sampleTime;


/*
 * Model states */
typedef struct
{
   float Memory[9];                 /* DSP 2: MOT/2-step AVG/Memory */
   bool Memory_1;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop1/Memory */
   bool Memory_2;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop2/Memory */
   bool Memory_3;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop3/Memory */
   bool Memory_4;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop/Memory */
   bool BR;                         /* DSP 2: MOT/Protection + Status/BR */
   float Delay;                     /* DSP 2: MOT/Protection + Status/Delay */
   bool Delay3;                     /* DSP 2: MOT/Protection + Status/Tower LED logic/Delay3 */
} DSP_2_MOT_ModelStates;
extern DSP_2_MOT_ModelStates DSP_2_MOT_X;


/* Block outputs */
typedef struct
{
   float PWMEN;                     /* DSP 2: MOT/Control Algorithm/PWM EN */
   float ERRRST;                    /* DSP 2: MOT/Control Algorithm/ERR RST */
   float ERRDSP;                    /* DSP 2: MOT/Control Algorithm/ERR DSP */
   float BR_EN;                     /* DSP 2: MOT/Protection + Status/BR_EN */
   bool LogicalOperator4;           /* DSP 2: MOT/Protection + Status/Tower LED logic/Logical Operator4 */
   bool ChipSelect_bool;            /* DSP 2: MOT/DACs/Chip Select */
   int32_t ChipSelect_int32_t;      /* DSP 2: MOT/DACs/Chip Select */
   uint16_t ChipSelect_uint16_t[2]; /* DSP 2: MOT/DACs/Chip Select */
   bool LogicalOperator2;           /* DSP 2: MOT/Protection + Status/Logical Operator2 */
   bool nA_B_bool;                  /* DSP 2: MOT/DACs/nA/B */
   int32_t nA_B_int32_t;            /* DSP 2: MOT/DACs/nA/B */
   uint16_t nA_B_uint16_t;          /* DSP 2: MOT/DACs/nA/B */
   float DACDemoWave;               /* DSP 2: MOT/DAC demo wave */
   uint8_t CANPack[8];              /* DSP 2: MOT/CAN Pack */
   float AnalogIn[9];               /* DSP 2: MOT/Analog In */
   float Memory[9];                 /* DSP 2: MOT/2-step AVG/Memory */
   float Gain[9];                   /* DSP 2: MOT/2-step AVG/Gain */
   float PWM_EN;                    /* DSP 2: MOT/PWM_EN */
   bool LogicalOperator;            /* DSP 2: MOT/Logical Operator */
   float Load[5];                   /* DSP 2: MOT/Control Algorithm/Load */
   bool Memory_1;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop1/Memory */
   bool LogicalOperator_1;          /* DSP 2: MOT/Protection + Status/SR Flip-flop1/Logical Operator */
   bool LogicalOperator8;           /* DSP 2: MOT/Protection + Status/Logical Operator8 */
   bool Memory_2;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop2/Memory */
   bool LogicalOperator_2;          /* DSP 2: MOT/Protection + Status/SR Flip-flop2/Logical Operator */
   bool CompareToConstant1;         /* DSP 2: MOT/Protection + Status/Compare to Constant1 */
   bool Memory_3;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop3/Memory */
   bool LogicalOperator_3;          /* DSP 2: MOT/Protection + Status/SR Flip-flop3/Logical Operator */
   double DataType5;                /* DSP 2: MOT/Protection + Status/Data Type5 */
   bool Memory_4;                   /* DSP 2: MOT/Protection + Status/SR Flip-flop/Memory */
   bool LogicalOperator_4;          /* DSP 2: MOT/Protection + Status/SR Flip-flop/Logical Operator */
   float Delay;                     /* DSP 2: MOT/Protection + Status/Delay */
   bool Delay3;                     /* DSP 2: MOT/Protection + Status/Tower LED logic/Delay3 */
   float CANReceive_float[3];       /* DSP 2: MOT/CAN Receive */
   uint8_t CANReceive_uint8_t[9];   /* DSP 2: MOT/CAN Receive */
} DSP_2_MOT_BlockOutputs;
extern DSP_2_MOT_BlockOutputs DSP_2_MOT_B;

#if defined(EXTERNAL_MODE) && EXTERNAL_MODE
/* External mode signals */
#define DSP_2_MOT_NumExtModeSignals 21
extern const float * const DSP_2_MOT_ExtModeSignals[];
/* Tunable parameters */
#define DSP_2_MOT_NumTunableParameters 4
#endif /* defined(EXTERNAL_MODE) */


/* Block parameters */
typedef struct
{
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/PWM EN'
    */
   bool PWMEN_SwitchState;
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR DSP'
    */
   bool ERRDSP_SwitchState;
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR RST'
    */
   bool ERRRST_SwitchState;
   /* Parameter 'Value' of
    *  Constant : 'DSP 2: MOT/DAC SEL (1,2,3)'
    */
   uint8_t DACSEL_1_2_3__Value;
} DSP_2_MOT_Parameters;
extern DSP_2_MOT_Parameters DSP_2_MOT_P;

/* Entry point functions */
void DSP_2_MOT_initialize(void);
void DSP_2_MOT_step(void);
void DSP_2_MOT_terminate(void);

#endif /* PLECS_HEADER_DSP_2_MOT_h_ */
