/*
 * Implementation file for: Exercise_0_Skeleton/DSP 2: MOT
 * Generated with         : PLECS 4.9.2
 *                          TI2833x 1.9.2
 * Generated on           : 17 Feb 2025 15:19:25
 */
#include "DSP_2_MOT.h"
#ifndef PLECS_HEADER_DSP_2_MOT_h_
#error The wrong header file "DSP_2_MOT.h" was included. Please check your
#error include path to see whether this file name conflicts with the name
#error of another header file.
#endif /* PLECS_HEADER_DSP_2_MOT_h_ */
#if defined(__GNUC__) && (__GNUC__ > 4)
#   define _ALIGNMENT 16
#   define _RESTRICT __restrict
#   define _ALIGN __attribute__((aligned(_ALIGNMENT)))
#   if defined(__clang__)
#      if __has_builtin(__builtin_assume_aligned)
#         define _ASSUME_ALIGNED(a) __builtin_assume_aligned(a, _ALIGNMENT)
#      else
#         define _ASSUME_ALIGNED(a) a
#      endif
#   else
#      define _ASSUME_ALIGNED(a) __builtin_assume_aligned(a, _ALIGNMENT)
#   endif
#else
#   ifndef _RESTRICT
#      define _RESTRICT
#   endif
#   ifndef _ALIGN
#      define _ALIGN
#   endif
#   ifndef _ASSUME_ALIGNED
#      define _ASSUME_ALIGNED(a) a
#   endif
#endif
#include <stdint.h>
#include <stdbool.h>
#include <math.h>
#include <string.h>
#include "plx_hal.h"
#include <stdlib.h>
#define PLECSRunTimeError(msg) DSP_2_MOT_errorStatus = msg
static const uint32_t DSP_2_MOT_subTaskPeriod[2]= {
   /* [0.75, 0], [0, 0] */
   7500,
   /* [1, 0], [0, 0] */
   10000
};
static uint32_t DSP_2_MOT_subTaskTick[2];
static char DSP_2_MOT_subTaskHit[2];
#define DSP_2_MOT_UNCONNECTED 0
static uint32_t DSP_2_MOT_D_uint32_t[1];
static uint32_t DSP_2_MOT_tickLo;
static int32_t DSP_2_MOT_tickHi;
DSP_2_MOT_BlockOutputs DSP_2_MOT_B;
#if defined(EXTERNAL_MODE) && EXTERNAL_MODE
static float DSP_2_MOT_ExtModeBuffer[6];
const float * const DSP_2_MOT_ExtModeSignals[] = {
   &DSP_2_MOT_B.Load[0],
   &DSP_2_MOT_ExtModeBuffer[0],
   &DSP_2_MOT_B.Gain[2],
   &DSP_2_MOT_B.Gain[3],
   &DSP_2_MOT_B.Gain[5],
   &DSP_2_MOT_B.Gain[4],
   &DSP_2_MOT_B.Gain[8],
   &DSP_2_MOT_B.Gain[1],
   &DSP_2_MOT_B.Gain[0],
   &DSP_2_MOT_B.Gain[6],
   &DSP_2_MOT_B.Gain[7],
   &DSP_2_MOT_ExtModeBuffer[1],
   &DSP_2_MOT_ExtModeBuffer[2],
   &DSP_2_MOT_ExtModeBuffer[3],
   &DSP_2_MOT_B.Gain[0],
   &DSP_2_MOT_B.Gain[1],
   &DSP_2_MOT_B.Gain[2],
   &DSP_2_MOT_B.Gain[4],
   &DSP_2_MOT_B.Gain[3],
   &DSP_2_MOT_ExtModeBuffer[4],
   &DSP_2_MOT_ExtModeBuffer[5]
};
#endif /* defined(EXTERNAL_MODE) */
DSP_2_MOT_Parameters DSP_2_MOT_P = {
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/PWM EN'
    */
   false,
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR DSP'
    */
   false,
   /* Parameter 'SwitchState' of
    *  Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR RST'
    */
   false,
   /* Parameter 'Value' of
    *  Constant : 'DSP 2: MOT/DAC SEL (1,2,3)'
    */
   3
};
DSP_2_MOT_ModelStates DSP_2_MOT_X _ALIGN;
const char * DSP_2_MOT_errorStatus;
const float DSP_2_MOT_sampleTime = 0.0001f;
const char * const DSP_2_MOT_checksum =
   "df411020eb87fd8eca0c597e40871154ca979e0b";
/* Target declarations */
// tag step function to allow special linking
#pragma CODE_SECTION(DSP_2_MOT_step, "step")
extern void DSP_2_MOT_initHal();

void DSP_2_MOT_initialize(void)
{
   DSP_2_MOT_tickHi = 0;
   DSP_2_MOT_tickLo = 0;
   /* Initialize sub-task tick counters */
   DSP_2_MOT_subTaskTick[0] = 0;    /* [0, 0], [0.75, 0] */
   DSP_2_MOT_subTaskTick[1] = 0;    /* [0, 0], [1, 0] */
   memset(&DSP_2_MOT_X, 0, sizeof(DSP_2_MOT_X));

   /* Target pre-initialization */
   DSP_2_MOT_initHal();


   /* Initialization for Memory : 'DSP 2: MOT/2-step AVG/Memory' */
   DSP_2_MOT_X.Memory[0] = 0.f;
   DSP_2_MOT_X.Memory[1] = 0.f;
   DSP_2_MOT_X.Memory[2] = 0.f;
   DSP_2_MOT_X.Memory[3] = 0.f;
   DSP_2_MOT_X.Memory[4] = 0.f;
   DSP_2_MOT_X.Memory[5] = 0.f;
   DSP_2_MOT_X.Memory[6] = 0.f;
   DSP_2_MOT_X.Memory[7] = 0.f;
   DSP_2_MOT_X.Memory[8] = 0.f;

   /* Initialization for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Memory' */
   DSP_2_MOT_X.Memory_1 = false;

   /* Initialization for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Memory' */
   DSP_2_MOT_X.Memory_2 = false;

   /* Initialization for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Memory' */
   DSP_2_MOT_X.Memory_3 = false;

   /* Initialization for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Memory' */
   DSP_2_MOT_X.Memory_4 = false;

   /* Initialization for Relay : 'DSP 2: MOT/Protection + Status/BR' */
   DSP_2_MOT_X.BR = 0;

   /* Initialization for Delay : 'DSP 2: MOT/Protection + Status/Delay' */
   DSP_2_MOT_X.Delay = 0.f;

   /* Initialization for Delay : 'DSP 2: MOT/Protection + Status/Tower LED logic/Delay3' */
   DSP_2_MOT_X.Delay3 = false;

   /* Initialization for Triangular Wave Generator : 'DSP 2: MOT/DAC demo wave' */
   DSP_2_MOT_D_uint32_t[0] = 0;
}

void DSP_2_MOT_step(void)
{
   if (DSP_2_MOT_errorStatus)
   {
      return;
   }
   {
      size_t i;
      for (i = 0; i < 2; ++i)
      {
         DSP_2_MOT_subTaskHit[i] = (DSP_2_MOT_subTaskTick[i] == 0);
      }
   }

   /* ADC : 'DSP 2: MOT/Analog In' */
   DSP_2_MOT_B.AnalogIn[0] = PLXHAL_ADC_getIn(0, 0);
   DSP_2_MOT_B.AnalogIn[1] = PLXHAL_ADC_getIn(0, 1);
   DSP_2_MOT_B.AnalogIn[2] = PLXHAL_ADC_getIn(0, 2);
   DSP_2_MOT_B.AnalogIn[3] = PLXHAL_ADC_getIn(0, 3);
   DSP_2_MOT_B.AnalogIn[4] = PLXHAL_ADC_getIn(0, 4);
   DSP_2_MOT_B.AnalogIn[5] = PLXHAL_ADC_getIn(0, 5);
   DSP_2_MOT_B.AnalogIn[6] = PLXHAL_ADC_getIn(0, 6);
   DSP_2_MOT_B.AnalogIn[7] = PLXHAL_ADC_getIn(0, 7);
   DSP_2_MOT_B.AnalogIn[8] = PLXHAL_ADC_getIn(0, 8);

   /* Memory : 'DSP 2: MOT/2-step AVG/Memory' */
   DSP_2_MOT_B.Memory[0] = DSP_2_MOT_X.Memory[0];
   DSP_2_MOT_B.Memory[1] = DSP_2_MOT_X.Memory[1];
   DSP_2_MOT_B.Memory[2] = DSP_2_MOT_X.Memory[2];
   DSP_2_MOT_B.Memory[3] = DSP_2_MOT_X.Memory[3];
   DSP_2_MOT_B.Memory[4] = DSP_2_MOT_X.Memory[4];
   DSP_2_MOT_B.Memory[5] = DSP_2_MOT_X.Memory[5];
   DSP_2_MOT_B.Memory[6] = DSP_2_MOT_X.Memory[6];
   DSP_2_MOT_B.Memory[7] = DSP_2_MOT_X.Memory[7];
   DSP_2_MOT_B.Memory[8] = DSP_2_MOT_X.Memory[8];

   /* Gain : 'DSP 2: MOT/2-step AVG/Gain'
    * incorporates
    *  Sum : 'DSP 2: MOT/2-step AVG/Sum1'
    */
   DSP_2_MOT_B.Gain[0] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[0] + DSP_2_MOT_B.Memory[0]);
   DSP_2_MOT_B.Gain[1] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[1] + DSP_2_MOT_B.Memory[1]);
   DSP_2_MOT_B.Gain[2] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[2] + DSP_2_MOT_B.Memory[2]);
   DSP_2_MOT_B.Gain[3] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[3] + DSP_2_MOT_B.Memory[3]);
   DSP_2_MOT_B.Gain[4] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[4] + DSP_2_MOT_B.Memory[4]);
   DSP_2_MOT_B.Gain[5] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[5] + DSP_2_MOT_B.Memory[5]);
   DSP_2_MOT_B.Gain[6] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[6] + DSP_2_MOT_B.Memory[6]);
   DSP_2_MOT_B.Gain[7] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[7] + DSP_2_MOT_B.Memory[7]);
   DSP_2_MOT_B.Gain[8] = 0.5f*
                         (DSP_2_MOT_B.AnalogIn[8] + DSP_2_MOT_B.Memory[8]);

   /* Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/PWM EN'
    * incorporates
    *  Constant : 'DSP 2: MOT/Control Algorithm/EN'
    *  Constant : 'DSP 2: MOT/Control Algorithm/DIS'
    */
   DSP_2_MOT_B.PWMEN = DSP_2_MOT_P.PWMEN_SwitchState ? 1.f : 0.f;

   /* Powerstage Protection : 'DSP 2: MOT/PWM_EN' */
   {
      if((DSP_2_MOT_B.PWMEN) > 0)
      {
         PLXHAL_PWR_setEnableRequest(true);
      }
      else
      {
         PLXHAL_PWR_setEnableRequest(false);
      }
   }
   DSP_2_MOT_B.PWM_EN = PLXHAL_PWR_isEnabled();

   /* Logical Operator : 'DSP 2: MOT/Logical\nOperator'
    * incorporates
    *  Compare to Constant : 'DSP 2: MOT/Compare to\nConstant'
    */
   DSP_2_MOT_B.LogicalOperator = (DSP_2_MOT_B.Gain[8] <= 0.5f) &&
                                 DSP_2_MOT_B.PWM_EN;

   /* CPU Load : 'DSP 2: MOT/Control Algorithm/Load' */
   DSP_2_MOT_B.Load[0] = PLXHAL_DISPR_getTask0LoadInPercent();
   DSP_2_MOT_B.Load[1] = PLXHAL_DISPR_getTimeStamp0();
   DSP_2_MOT_B.Load[2] = PLXHAL_DISPR_getTimeStampB();
   DSP_2_MOT_B.Load[3] = PLXHAL_DISPR_getTimeStampD();
   DSP_2_MOT_B.Load[4] = PLXHAL_DISPR_getTimeStampP();

   /* Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR RST'
    * incorporates
    *  Constant : 'DSP 2: MOT/Control Algorithm/EN2'
    *  Constant : 'DSP 2: MOT/Control Algorithm/DIS2'
    */
   DSP_2_MOT_B.ERRRST = DSP_2_MOT_P.ERRRST_SwitchState ? 1.f : 0.f;

   /* Manual Signal Switch : 'DSP 2: MOT/Control Algorithm/ERR DSP'
    * incorporates
    *  Constant : 'DSP 2: MOT/Control Algorithm/EN1'
    *  Constant : 'DSP 2: MOT/Control Algorithm/DIS1'
    */
   DSP_2_MOT_B.ERRDSP = DSP_2_MOT_P.ERRDSP_SwitchState ? 1.f : 0.f;

   /* Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Memory' */
   DSP_2_MOT_B.Memory_1 = DSP_2_MOT_X.Memory_1;

   /* Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Logical\nOperator1'
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Logical\nOperator2'
    */
   DSP_2_MOT_B.LogicalOperator_1 = (!DSP_2_MOT_B.ERRRST) &&
                                   (DSP_2_MOT_B.ERRDSP ||
                                    DSP_2_MOT_B.Memory_1);

   /* Logical Operator : 'DSP 2: MOT/Protection + Status/Logical\nOperator8'
    * incorporates
    *  Compare to Constant : 'DSP 2: MOT/Protection + Status/Compare to\nConstant'
    *  Abs : 'DSP 2: MOT/Protection + Status/Abs'
    */
   DSP_2_MOT_B.LogicalOperator8 = (fabsf(DSP_2_MOT_B.Gain[0]) > 10.f) ||
                                  (fabsf(DSP_2_MOT_B.Gain[1]) > 10.f) ||
                                  (fabsf(DSP_2_MOT_B.Gain[2]) > 10.f);

   /* Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Memory' */
   DSP_2_MOT_B.Memory_2 = DSP_2_MOT_X.Memory_2;

   /* Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Logical\nOperator1'
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Logical\nOperator2'
    */
   DSP_2_MOT_B.LogicalOperator_2 = (!DSP_2_MOT_B.ERRRST) &&
                                   (DSP_2_MOT_B.LogicalOperator8 ||
                                    DSP_2_MOT_B.Memory_2);

   /* Compare to Constant : 'DSP 2: MOT/Protection + Status/Compare to\nConstant1' */
   DSP_2_MOT_B.CompareToConstant1 = DSP_2_MOT_B.Gain[3] > 760.f;

   /* Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Memory' */
   DSP_2_MOT_B.Memory_3 = DSP_2_MOT_X.Memory_3;

   /* Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Logical\nOperator1'
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Logical\nOperator2'
    */
   DSP_2_MOT_B.LogicalOperator_3 = (!DSP_2_MOT_B.ERRRST) &&
                                   (DSP_2_MOT_B.CompareToConstant1 ||
                                    DSP_2_MOT_B.Memory_3);

   /* Data Type : 'DSP 2: MOT/Protection + Status/Data Type5'
    * incorporates
    *  Sum : 'DSP 2: MOT/Protection + Status/Sum1'
    *  Data Type : 'DSP 2: MOT/Protection + Status/Data Type1'
    *  Gain : 'DSP 2: MOT/Protection + Status/Gain'
    *  Data Type : 'DSP 2: MOT/Protection + Status/Data Type2'
    *  Gain : 'DSP 2: MOT/Protection + Status/Gain1'
    *  Data Type : 'DSP 2: MOT/Protection + Status/Data Type3'
    */
   DSP_2_MOT_B.DataType5 =
      (double)(((float)DSP_2_MOT_B.LogicalOperator_1) +
               (2.f*
                ((float)DSP_2_MOT_B.LogicalOperator_2)) +
               (4.f*((float)DSP_2_MOT_B.LogicalOperator_3)));

   /* PWM : 'DSP 2: MOT/PWMs Out' */

   PLXHAL_PWM_setDuty(0, 0.f);

   PLXHAL_PWM_setDuty(1, 0.f);

   PLXHAL_PWM_setDuty(2, 0.f);


   /* Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Memory' */
   DSP_2_MOT_B.Memory_4 = DSP_2_MOT_X.Memory_4;

   /* Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Logical\nOperator'
    * incorporates
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Logical\nOperator1'
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Logical\nOperator2'
    *  Logical Operator : 'DSP 2: MOT/Protection + Status/Logical\nOperator7'
    */
   DSP_2_MOT_B.LogicalOperator_4 = (!DSP_2_MOT_B.ERRRST) &&
                                   ((DSP_2_MOT_B.ERRDSP ||
                                     DSP_2_MOT_B.LogicalOperator8 ||
                                     DSP_2_MOT_B.CompareToConstant1) ||
                                    DSP_2_MOT_B.Memory_4);

   /* Relay : 'DSP 2: MOT/Protection + Status/BR' */
   {
      float u = DSP_2_MOT_B.Gain[3];
      if (DSP_2_MOT_X.BR && u < 600.f)
      {
         DSP_2_MOT_X.BR = 0;
      }
      else if (!DSP_2_MOT_X.BR && u > 630.f)
      {
         DSP_2_MOT_X.BR = 1;
      }
   }
   /* Manual Signal Switch : 'DSP 2: MOT/Protection + Status/BR_EN'
    * incorporates
    *  Relay : 'DSP 2: MOT/Protection + Status/BR'
    *  Constant : 'DSP 2: MOT/Protection + Status/DIS3'
    */
   DSP_2_MOT_B.BR_EN = true ? ((DSP_2_MOT_X.BR) ? 1.f : 0.f) : 0.f;
   if (DSP_2_MOT_subTaskHit[1])
   {
      /* Delay : 'DSP 2: MOT/Protection + Status/Delay' */
      DSP_2_MOT_B.Delay = DSP_2_MOT_X.Delay;

      /* Logical Operator : 'DSP 2: MOT/Protection + Status/Logical\nOperator2' */
      DSP_2_MOT_B.LogicalOperator2 = !DSP_2_MOT_B.Delay;
   }
   if (DSP_2_MOT_subTaskHit[0])
   {
      /* Delay : 'DSP 2: MOT/Protection + Status/Tower LED logic/Delay3' */
      DSP_2_MOT_B.Delay3 = DSP_2_MOT_X.Delay3;

      /* Logical Operator : 'DSP 2: MOT/Protection + Status/Tower LED logic/Logical\nOperator4' */
      DSP_2_MOT_B.LogicalOperator4 = !DSP_2_MOT_B.Delay3;
   }
   /* Multiport Signal Switch : 'DSP 2: MOT/DACs/Chip Select'
    * incorporates
    *  Constant : 'DSP 2: MOT/DAC SEL (1,2,3)'
    *  Constant : 'DSP 2: MOT/DACs/CHIP 1'
    *  Constant : 'DSP 2: MOT/DACs/CHIP 2'
    */
   DSP_2_MOT_B.ChipSelect_bool = false;
   DSP_2_MOT_B.ChipSelect_int32_t = (int32_t)DSP_2_MOT_P.DACSEL_1_2_3__Value;
   switch (DSP_2_MOT_B.ChipSelect_int32_t)
   {
   default:
      DSP_2_MOT_B.ChipSelect_bool = true;
      DSP_2_MOT_B.ChipSelect_int32_t = 1;

   // Fall through, no break;
   case 1:
      DSP_2_MOT_B.ChipSelect_uint16_t[0] = 0;
      DSP_2_MOT_B.ChipSelect_uint16_t[1] = 1;
      break;

   case 2:
      DSP_2_MOT_B.ChipSelect_uint16_t[0] = 0;
      DSP_2_MOT_B.ChipSelect_uint16_t[1] = 1;
      break;

   case 3:
      DSP_2_MOT_B.ChipSelect_uint16_t[0] = 1;
      DSP_2_MOT_B.ChipSelect_uint16_t[1] = 0;
      break;
   }
   /* Digital Out : 'DSP 2: MOT/Digital Out' */
   PLXHAL_DIO_set(0, ((float)(!DSP_2_MOT_B.LogicalOperator_4)));
   PLXHAL_DIO_set(1, ((float)(!DSP_2_MOT_B.ERRRST)));
   PLXHAL_DIO_set(2, ((float)(!DSP_2_MOT_B.BR_EN)));
   PLXHAL_DIO_set(3, ((float)DSP_2_MOT_B.LogicalOperator2));
   PLXHAL_DIO_set(4, 0.f);
   PLXHAL_DIO_set(5,
                  ((float)(!(((DSP_2_MOT_B.Gain[8] > 0.2f) &&
                              DSP_2_MOT_B.LogicalOperator4) ||
                             DSP_2_MOT_B.PWM_EN))));
   PLXHAL_DIO_set(6, 0.f);
   PLXHAL_DIO_set(7, 0.f);
   PLXHAL_DIO_set(8, 0.f);
   PLXHAL_DIO_set(9, 0.f);
   PLXHAL_DIO_set(10, ((float)DSP_2_MOT_B.ChipSelect_uint16_t[0]));
   PLXHAL_DIO_set(11, ((float)DSP_2_MOT_B.ChipSelect_uint16_t[1]));


   /* Multiport Signal Switch : 'DSP 2: MOT/DACs/nA\/B'
    * incorporates
    *  Constant : 'DSP 2: MOT/DAC SEL (1,2,3)'
    *  Constant : 'DSP 2: MOT/DACs/cst'
    *  Constant : 'DSP 2: MOT/DACs/cst1'
    *  Constant : 'DSP 2: MOT/DACs/cst2'
    */
   DSP_2_MOT_B.nA_B_bool = false;
   DSP_2_MOT_B.nA_B_int32_t = (int32_t)DSP_2_MOT_P.DACSEL_1_2_3__Value;
   switch (DSP_2_MOT_B.nA_B_int32_t)
   {
   default:
      DSP_2_MOT_B.nA_B_bool = true;
      DSP_2_MOT_B.nA_B_int32_t = 1;

   // Fall through, no break;
   case 1:
      DSP_2_MOT_B.nA_B_uint16_t = 0;
      break;

   case 2:
      DSP_2_MOT_B.nA_B_uint16_t = 1;
      break;

   case 3:
      DSP_2_MOT_B.nA_B_uint16_t = 0;
      break;
   }

   /* Triangular Wave Generator : 'DSP 2: MOT/DAC demo wave' */
   {
      float frac;
      if (DSP_2_MOT_D_uint32_t[0] < 50)
      {
         frac = DSP_2_MOT_D_uint32_t[0]*((float)1/50);
      }
      else
      {
         frac = 1-(DSP_2_MOT_D_uint32_t[0]-50)*((float)1/50);
      }
      DSP_2_MOT_B.DACDemoWave = 0.f+1.f*frac;
   }

   /* SPI Controller : 'DSP 2: MOT/SPI to DACs' */
   static uint16_t SpiController0PeripheralCsHandles[] = {
      12
   };
   static uint16_t SpiController0PeripheralWordsPerTransmission[] = {
      1
   };
   static uint16_t SpiController0RxData[1] = {
      0
   };
   static uint16_t SpiController0TxData[1];
   static uint16_t SpiController0RxDataBuffer[1];
   static uint16_t SpiController0PeripheralIndex = 0;
   static uint16_t SpiController0PeripheralDataIndex = 0;
   static bool SpiController0PeripheralTxActive = false;
   static bool SpiController0Ready = false;
   static bool SpiController0TxOverrun = false;
   SpiController0Ready = false;
   if(SpiController0PeripheralTxActive)
   {
      // de-assert last CS
      PLXHAL_DIO_set(SpiController0PeripheralCsHandles[
                        SpiController0PeripheralIndex], true);

      SpiController0TxOverrun =
         (PLXHAL_SPI_getRxFifoLevel(0) !=
          SpiController0PeripheralWordsPerTransmission[
             SpiController0PeripheralIndex]);
      if(SpiController0TxOverrun)
      {
         // overrun occurred
         SpiController0PeripheralIndex = 0;
         SpiController0PeripheralTxActive = false;
      }
      else
      {
         // read data
         PLXHAL_SPI_getWords(0,
                             &SpiController0RxDataBuffer[
                                SpiController0PeripheralDataIndex],
                             SpiController0PeripheralWordsPerTransmission[
                                SpiController0PeripheralIndex]);                                                                                                                            // FIXME: incorrect index

         // next peripheral
         SpiController0PeripheralDataIndex +=
            SpiController0PeripheralWordsPerTransmission[
               SpiController0PeripheralIndex];
         SpiController0PeripheralIndex++;
         if(SpiController0PeripheralIndex == 1)
         {
            // all peripherals have been serviced
            SpiController0RxData[0] = SpiController0RxDataBuffer[0];
            SpiController0Ready = true;

            SpiController0PeripheralIndex = 0;
            SpiController0PeripheralTxActive = false;
         }
      }
   }

   // prime next transmission
   if(SpiController0PeripheralIndex == 0)
   {
      SpiController0TxData[0] =
         (((uint32_t)((uint16_t)(32768*
                                 DSP_2_MOT_B.nA_B_uint16_t))) +
          ((uint32_t)0) + ((uint32_t)0) +
          ((uint32_t)4096) +
          ((uint32_t)((uint16_t)(1*
                                 ((uint16_t)(4095*
                                             ((uint16_t)DSP_2_MOT_B.
                                              DACDemoWave)))))));
      SpiController0PeripheralDataIndex = 0;
      SpiController0PeripheralTxActive = true;
   }

   if(SpiController0PeripheralTxActive)
   {
      PLXHAL_DIO_set(SpiController0PeripheralCsHandles[
                        SpiController0PeripheralIndex], false);
      PLXHAL_SPI_putWords(0,
                          &SpiController0TxData[
                             SpiController0PeripheralDataIndex],
                          SpiController0PeripheralWordsPerTransmission[
                             SpiController0PeripheralIndex]);
   }


   /* CAN Port : 'DSP 2: MOT/CAN Port' */
   {
      static bool lastBusOn = false;
      bool busOn = 1.f;
      if(!busOn)
      {
         PLXHAL_CAN_setBusOn(0, false);
      }
      else if (!lastBusOn)
      {
         PLXHAL_CAN_setBusOn(0, true);
      }
      lastBusOn = busOn;
   }

   /* CAN Pack : 'DSP 2: MOT/CAN Pack' */
   DSP_2_MOT_B.CANPack[0] = 0;
   DSP_2_MOT_B.CANPack[1] = 0;
   DSP_2_MOT_B.CANPack[2] = 0;
   DSP_2_MOT_B.CANPack[3] = 0;
   DSP_2_MOT_B.CANPack[4] = 0;
   DSP_2_MOT_B.CANPack[5] = 0;
   DSP_2_MOT_B.CANPack[6] = 0;
   DSP_2_MOT_B.CANPack[7] = 0;
   /* CAN Transmit : 'DSP 2: MOT/CAN Transmit' */
   {
      unsigned char canData[] = {
         DSP_2_MOT_B.CANPack[0], DSP_2_MOT_B.CANPack[1],
         DSP_2_MOT_B.CANPack[2], DSP_2_MOT_B.CANPack[3],
         DSP_2_MOT_B.CANPack[4], DSP_2_MOT_B.CANPack[5],
         DSP_2_MOT_B.CANPack[6], DSP_2_MOT_B.CANPack[7]
      };
      PLXHAL_CAN_putMessage(0, 0, canData, 8);
   }

   /* CAN Receive : 'DSP 2: MOT/CAN Receive' */
   {
      static unsigned char data[8] = {
         0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
      };
      static bool firstRun = true;
      DSP_2_MOT_B.CANReceive_uint8_t[8] = PLXHAL_CAN_getMessage(0, 1,
                                                                &data[0], 8);
      if(firstRun || DSP_2_MOT_B.CANReceive_uint8_t[8])
      {
         memcpy(&DSP_2_MOT_B.CANReceive_uint8_t[0], &data[0],
                8*sizeof(uint8_t));
         firstRun = false;
      }
   }
#if defined(EXTERNAL_MODE) && EXTERNAL_MODE
   DSP_2_MOT_ExtModeBuffer[0] = (float)DSP_2_MOT_B.LogicalOperator;
   DSP_2_MOT_ExtModeBuffer[1] = 0.f;
   DSP_2_MOT_ExtModeBuffer[2] = 0.f;
   DSP_2_MOT_ExtModeBuffer[3] = 0.f;
   DSP_2_MOT_ExtModeBuffer[4] = (float)DSP_2_MOT_B.LogicalOperator;
   DSP_2_MOT_ExtModeBuffer[5] = (float)DSP_2_MOT_B.DataType5;
#endif /* defined(EXTERNAL_MODE) */

   if (DSP_2_MOT_errorStatus)
   {
      return;
   }

   /* Update for Memory : 'DSP 2: MOT/2-step AVG/Memory' */
   DSP_2_MOT_X.Memory[0] = DSP_2_MOT_B.AnalogIn[0];
   DSP_2_MOT_X.Memory[1] = DSP_2_MOT_B.AnalogIn[1];
   DSP_2_MOT_X.Memory[2] = DSP_2_MOT_B.AnalogIn[2];
   DSP_2_MOT_X.Memory[3] = DSP_2_MOT_B.AnalogIn[3];
   DSP_2_MOT_X.Memory[4] = DSP_2_MOT_B.AnalogIn[4];
   DSP_2_MOT_X.Memory[5] = DSP_2_MOT_B.AnalogIn[5];
   DSP_2_MOT_X.Memory[6] = DSP_2_MOT_B.AnalogIn[6];
   DSP_2_MOT_X.Memory[7] = DSP_2_MOT_B.AnalogIn[7];
   DSP_2_MOT_X.Memory[8] = DSP_2_MOT_B.AnalogIn[8];

   /* Update for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop1/Memory' */
   DSP_2_MOT_X.Memory_1 = DSP_2_MOT_B.LogicalOperator_1;

   /* Update for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop2/Memory' */
   DSP_2_MOT_X.Memory_2 = DSP_2_MOT_B.LogicalOperator_2;

   /* Update for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop3/Memory' */
   DSP_2_MOT_X.Memory_3 = DSP_2_MOT_B.LogicalOperator_3;

   /* Update for PWM : 'DSP 2: MOT/PWMs Out' */
   PLXHAL_PWR_syncdPwmEnable();

   /* Update for Memory : 'DSP 2: MOT/Protection + Status/SR Flip-flop/Memory' */
   DSP_2_MOT_X.Memory_4 = DSP_2_MOT_B.LogicalOperator_4;
   if (DSP_2_MOT_subTaskHit[1])
   {
      /* Update for Delay : 'DSP 2: MOT/Protection + Status/Delay'
       * incorporates
       *  Constant : 'DSP 2: MOT/Protection + Status/Constant'
       */
      DSP_2_MOT_X.Delay = 1.f;
   }
   if (DSP_2_MOT_subTaskHit[0])
   {
      /* Update for Delay : 'DSP 2: MOT/Protection + Status/Tower LED logic/Delay3' */
      DSP_2_MOT_X.Delay3 = DSP_2_MOT_B.LogicalOperator4;
   }
   /* Update for Triangular Wave Generator : 'DSP 2: MOT/DAC demo wave' */
   DSP_2_MOT_D_uint32_t[0] += 1;
   if (DSP_2_MOT_D_uint32_t[0] > 99)
   {
      DSP_2_MOT_D_uint32_t[0] -= 100;
   }
   /* Increment sub-task tick counters */
   {
      size_t i;
      for (i = 0; i < 2; ++i)
      {
         DSP_2_MOT_subTaskTick[i]++;
         if (DSP_2_MOT_subTaskTick[i] >= DSP_2_MOT_subTaskPeriod[i])
         {
            DSP_2_MOT_subTaskTick[i] = 0;
         }
      }
   }
}

void DSP_2_MOT_terminate(void)
{
}
