// File: GameScreen.kt
package com.epfl.esl.android_midterm_2024

import androidx.compose.foundation.Image
import androidx.compose.foundation.background
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.*
import androidx.compose.material3.Button
import androidx.compose.material3.Text
import androidx.compose.runtime.*
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.asImageBitmap
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.unit.dp
import androidx.navigation.NavController

@Composable
fun GameScreen(
    navController: NavController,
    gameViewModel: GameViewModel
) {
    val context = LocalContext.current
    // Initialize the game
    LaunchedEffect(Unit) {
        gameViewModel.initializeGame(context)
    }

    // Observe the displayedImage
    val displayedImage = gameViewModel.displayedImage.value

    //* TODO: Checkpoint 3
    // Observe the number of retries left from the gameViewModel. Remember to remove the
    // instance of the local state variable from the TODO 2. *//



    // END TODO 3

    //* TODO: Checkpoint 2
    // Hoist the declaration of the retriesLeft state variable here, so that the background
    // color and the Retry button are updated according to its value. The initial value of
    // retriesLeft should be 3. Note that passing of event and value parameters is not required,
    // since the value is hoisted inside the same function.
    // Use the pickBackgroundColor() function from the gameViewModel to determine the background
    // color based on the number of retries left. *//

    val backgroundColor = Color(0xFFB7FFBA)


    // END TODO 2

    Column(
        modifier = Modifier
            .fillMaxSize()
            .background(backgroundColor)
            .padding(16.dp),
        horizontalAlignment = Alignment.CenterHorizontally,
        verticalArrangement = Arrangement.Center
    ) {
        // Display the large image
        displayedImage?.let {
            Image(
                bitmap = it.asImageBitmap(),
                contentDescription = "Puzzle Image",
                modifier = Modifier.size(300.dp),
                contentScale = ContentScale.FillBounds
            )
        }

        Spacer(modifier = Modifier.height(16.dp))

        // Display options
        Row(
            horizontalArrangement = Arrangement.SpaceEvenly,
            modifier = Modifier.fillMaxWidth()
        ) {
            gameViewModel.options.value.forEach { option ->
                Image(
                    bitmap = option.asImageBitmap(),
                    contentDescription = "Option",
                    modifier = Modifier
                        .size(80.dp)
                        .clickable {
                            //* TODO: Checkpoint 1
                            // Implement the navigation to the correct screen: if the selected
                            // tile is the correct one, navigate to the WinScreen; otherwise,
                            // navigate to the LoseScreen. *//

                            if (option == gameViewModel.imageBlocks[gameViewModel.missingPieceIndex.value]) {

                            } else {

                            }

                            // END TODO 1
                        }
                        .padding(8.dp),
                    contentScale = ContentScale.FillBounds
                )
            }
        }

        Spacer(modifier = Modifier.height(16.dp))

        //* TODO: Checkpoint 2
        // Make retriesLeft a State variable. Then, hoist it to the correct level (above) so that the
        // background color and the Retry button are updated according to its value. The initial
        // value of retriesLeft should be 3. *//

        var retriesLeft = 3


        // END TODO 2

        // Retry Button
        Button(
            onClick = {
                // Generate a new puzzle
                gameViewModel.generateNewPuzzle(context)

                //* TODO: Checkpoint 3
                // Modify the code to use the decrementRetries method from the gameViewModel
                // to decrement the number of retries left *//

                retriesLeft--


                // END TODO 3
            },
            enabled = retriesLeft.let { it > 0 }
        ) {
            Text(
                "Retry\n${retriesLeft} retries left",
                textAlign = TextAlign.Center
            )
        }
    }
}
